/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.templates;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPContextProvider;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableWithProgress;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public abstract class SQLObjectResolver<T extends DBSObject>
extends TemplateVariableResolver {
    private static final Log log = Log.getLog(SQLObjectResolver.class);

    public SQLObjectResolver(String type, String description) {
        super(type, description);
    }

    protected String[] resolveAll(final TemplateContext context) {
        DBCExecutionContext executionContext;
        final ArrayList entities = new ArrayList();
        if (context instanceof DBPContextProvider && (executionContext = ((DBPContextProvider)context).getExecutionContext()) != null) {
            RuntimeUtils.runTask((DBRRunnableWithProgress)new DBRRunnableWithProgress(){

                public void run(DBRProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        SQLObjectResolver.this.resolveObjects(monitor, executionContext, context, entities);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            }, (String)"Resolve object references", (long)1000L);
        }
        if (!CommonUtils.isEmpty(entities)) {
            String[] result = new String[entities.size()];
            for (int i = 0; i < entities.size(); ++i) {
                DBSObject entity = (DBSObject)entities.get(i);
                result[i] = entity.getName();
            }
            return result;
        }
        return super.resolveAll(context);
    }

    protected abstract void resolveObjects(DBRProgressMonitor var1, DBCExecutionContext var2, TemplateContext var3, List<T> var4) throws DBException;
}

