/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.scripts;

import java.io.File;
import java.nio.file.Path;
import java.util.List;
import org.eclipse.ui.IWorkbenchWindow;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.file.FileTypeAction;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.DatabaseEditorContext;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.file.AbstractFileHandler;
import org.jkiss.dbeaver.ui.editors.sql.handlers.SQLNavigatorContext;
import org.jkiss.utils.IOUtils;

public class SQLFileHandler
extends AbstractFileHandler {
    public void openFiles(@NotNull List<Path> fileList, @Nullable DBPDataSourceContainer dataSource, @NotNull FileTypeAction action) throws DBException {
        if (action == FileTypeAction.INTERNAL_EDITOR) {
            for (Path path : fileList) {
                if (!IOUtils.isLocalPath((Path)path) && this.sourceNode != null) {
                    if (this.tryOpenViaResourceAdapter(path, this.sourceNode)) continue;
                    throw new DBException("Cannot open remote file: " + String.valueOf(path));
                }
                if (dataSource != null) {
                    File file = path.toFile();
                    EditorUtils.setFileDataSource((File)file, (DatabaseEditorContext)new SQLNavigatorContext((DBSObject)dataSource));
                }
                EditorUtils.openExternalFileEditor((Path)path, (IWorkbenchWindow)UIUtils.getActiveWorkbenchWindow());
            }
        } else {
            super.openFiles(fileList, dataSource, action);
        }
    }
}

