/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.editor.tools;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.ui.SharedFonts;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDEditorPart;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIMessages;
import org.jkiss.dbeaver.ui.editors.erd.part.EntityPart;
import org.jkiss.dbeaver.ui.editors.erd.part.ICustomizablePart;
import org.jkiss.dbeaver.ui.editors.erd.part.NodePart;
import org.jkiss.dbeaver.ui.editors.erd.part.NotePart;
import org.jkiss.dbeaver.ui.editors.erd.part.PropertyAwarePart;
import org.jkiss.utils.CommonUtils;

public class SetPartSettingsAction
extends SelectionAction {
    private final IStructuredSelection selection;

    public SetPartSettingsAction(ERDEditorPart part, IStructuredSelection selection) {
        super((IWorkbenchPart)part);
        this.selection = selection;
        this.setText(ERDUIMessages.erd_settings_action_customize);
        this.setToolTipText(ERDUIMessages.erd_settings_action_customize_tip);
        this.setId("setPartSettings");
    }

    protected boolean calculateEnabled() {
        for (Object item : this.selection.toArray()) {
            if (!(item instanceof NodePart)) continue;
            return true;
        }
        return false;
    }

    protected void init() {
        super.init();
    }

    public void run() {
        this.execute(this.createColorCommand(this.selection.toArray()));
    }

    private Command createColorCommand(final Object[] objects) {
        return new Command(this){
            private ViewSettings newSettings;
            private final Map<ICustomizablePart, ViewSettings> oldSettings = new HashMap<ICustomizablePart, ViewSettings>();

            public void execute() {
                PropertyAwarePart nodePart = null;
                boolean hasNotes = false;
                boolean hasEntities = false;
                for (Object item : objects) {
                    if (!(item instanceof NodePart)) continue;
                    if (nodePart == null) {
                        nodePart = (NodePart)item;
                    }
                    if (item instanceof NotePart) {
                        hasNotes = true;
                        continue;
                    }
                    if (!(item instanceof EntityPart)) continue;
                    hasEntities = true;
                }
                PartSettingsDialog settingsDialog = new PartSettingsDialog(nodePart.getEditor().getSite().getShell(), (NodePart)nodePart, hasNotes, hasEntities);
                if (settingsDialog.open() != 0) {
                    return;
                }
                this.newSettings = settingsDialog.newSettings;
                for (Object item : objects) {
                    if (!(item instanceof ICustomizablePart)) continue;
                    ICustomizablePart part = (ICustomizablePart)item;
                    ViewSettings oldSettings = new ViewSettings();
                    oldSettings.transparency = part.getCustomTransparency();
                    oldSettings.background = part.getCustomBackgroundColor();
                    oldSettings.foreground = part.getCustomForegroundColor();
                    oldSettings.borderWidth = part.getCustomBorderWidth();
                    oldSettings.fontInfo = SharedFonts.toString((Font)part.getCustomFont());
                    this.oldSettings.put(part, oldSettings);
                    this.setNodeSettings(part, this.newSettings);
                }
            }

            public void undo() {
                for (Object item : objects) {
                    ICustomizablePart colorizedPart;
                    ViewSettings viewSettings;
                    if (!(item instanceof ICustomizablePart) || (viewSettings = this.oldSettings.get(colorizedPart = (ICustomizablePart)item)) == null) continue;
                    this.setNodeSettings(colorizedPart, viewSettings);
                }
            }

            public void redo() {
                for (Object item : objects) {
                    if (!(item instanceof ICustomizablePart)) continue;
                    this.setNodeSettings((ICustomizablePart)item, this.newSettings);
                }
            }

            private void setNodeSettings(ICustomizablePart part, ViewSettings settings) {
                if (part instanceof NotePart) {
                    part.setCustomTransparency(settings.transparency);
                }
                part.setCustomBackgroundColor(settings.background);
                if (part instanceof NotePart) {
                    part.setCustomForegroundColor(settings.foreground);
                    part.setCustomBorderWidth(settings.borderWidth);
                    part.setCustomFont(UIUtils.getSharedFonts().getFont((Device)Display.getCurrent(), settings.fontInfo));
                }
            }
        };
    }

    private static class PartSettingsDialog
    extends BaseDialog {
        private final NodePart node;
        private final boolean noteStyles;
        private final boolean entityStyles;
        private Button transparentCheckbox;
        private ColorSelector backgroundColorPicker;
        private ColorSelector foregroundColorPicker;
        private Text borderWidthText;
        private String fontData;
        private ViewSettings newSettings = new ViewSettings();

        public PartSettingsDialog(Shell parentShell, NodePart node, boolean noteStyles, boolean entityStyles) {
            super(parentShell, ERDUIMessages.erd_settings_dialog_text_title, null);
            this.node = node;
            this.noteStyles = noteStyles;
            this.entityStyles = entityStyles;
        }

        @NotNull
        protected Composite createDialogArea(@NotNull Composite parent) {
            Composite dialogArea = super.createDialogArea(parent);
            final Composite settingsGroup = UIUtils.createTitledComposite((Composite)dialogArea, (String)ERDUIMessages.erd_settings_dialog_group_label, (int)2, (int)768);
            if (this.noteStyles) {
                this.transparentCheckbox = UIUtils.createCheckbox((Composite)settingsGroup, (String)ERDUIMessages.erd_settings_checkbox_transparent_label, (String)ERDUIMessages.erd_settings_checkbox_transparent_tip, (this.node != null && this.node.getCustomTransparency() ? 1 : 0) != 0, (int)2);
            }
            UIUtils.createControlLabel((Composite)settingsGroup, (String)ERDUIMessages.erd_settings_color_picker_background_label);
            this.backgroundColorPicker = new ColorSelector(settingsGroup);
            if (this.node != null) {
                this.backgroundColorPicker.setColorValue(this.node.getCustomBackgroundColor().getRGB());
            }
            if (this.noteStyles) {
                UIUtils.createControlLabel((Composite)settingsGroup, (String)ERDUIMessages.erd_settings_color_picker_foreground_label);
                this.foregroundColorPicker = new ColorSelector(settingsGroup);
                if (this.node != null) {
                    this.foregroundColorPicker.setColorValue(this.node.getCustomForegroundColor().getRGB());
                }
                this.borderWidthText = UIUtils.createLabelText((Composite)settingsGroup, (String)ERDUIMessages.erd_settings_border_width_label, (String)String.valueOf(this.node == null ? 1 : this.node.getCustomBorderWidth()));
                GridData gd = new GridData(32);
                gd.widthHint = 30;
                this.borderWidthText.setLayoutData((Object)gd);
                this.borderWidthText.addVerifyListener(UIUtils.getIntegerVerifyListener((Locale)Locale.ENGLISH));
                UIUtils.createControlLabel((Composite)settingsGroup, (String)ERDUIMessages.erd_settings_font_label);
                Button changeFontButton = UIUtils.createPushButton((Composite)settingsGroup, (String)ERDUIMessages.erd_settings_button_change_font_label, null, null);
                changeFontButton.setLayoutData((Object)new GridData(2));
                final Text previewText = new Text(settingsGroup, 2058);
                previewText.setText(ERDUIMessages.erd_settings_font_preview_text);
                gd = new GridData(770);
                gd.horizontalSpan = 2;
                previewText.setLayoutData((Object)gd);
                if (this.node != null) {
                    previewText.setFont(this.node.getCustomFont());
                    this.fontData = SharedFonts.toString((FontData)this.node.getCustomFont().getFontData()[0]);
                }
                changeFontButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        FontDialog fontDialog = new FontDialog(this.getShell(), 0);
                        fontDialog.setFontList(previewText.getFont().getFontData());
                        FontData result = fontDialog.open();
                        if (result != null) {
                            fontData = SharedFonts.toString((FontData)result);
                            previewText.setFont(UIUtils.getSharedFonts().getFont((Device)previewText.getDisplay(), result));
                            settingsGroup.layout(true, true);
                        }
                    }
                });
            }
            return dialogArea;
        }

        protected void okPressed() {
            this.newSettings = new ViewSettings();
            this.newSettings.background = this.getBackgroundColor();
            this.newSettings.foreground = this.getForegroundColorPicker();
            this.newSettings.transparency = this.isTransparent();
            this.newSettings.borderWidth = this.getBorderWidth();
            this.newSettings.fontInfo = this.getFontData();
            super.okPressed();
        }

        public boolean isTransparent() {
            return this.transparentCheckbox != null && this.transparentCheckbox.getSelection();
        }

        public Color getBackgroundColor() {
            return this.backgroundColorPicker == null ? null : UIUtils.getSharedTextColors().getColor(this.backgroundColorPicker.getColorValue());
        }

        public Color getForegroundColorPicker() {
            return this.foregroundColorPicker == null ? null : UIUtils.getSharedTextColors().getColor(this.foregroundColorPicker.getColorValue());
        }

        public int getBorderWidth() {
            return this.borderWidthText == null ? 0 : CommonUtils.toInt((Object)this.borderWidthText.getText());
        }

        public String getFontData() {
            return this.fontData;
        }
    }

    private static class ViewSettings {
        private Color background;
        private Color foreground;
        private int borderWidth;
        private boolean transparency;
        private String fontInfo;

        private ViewSettings() {
        }
    }
}

