/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.text.handlers;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentRewriteSession;
import org.eclipse.jface.text.DocumentRewriteSessionType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension4;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.jkiss.dbeaver.ui.ICommentsSupport;
import org.jkiss.dbeaver.ui.editors.text.handlers.AbstractCommentHandler;
import org.jkiss.utils.ArrayUtils;

public final class ToggleSingleLineCommentHandler
extends AbstractCommentHandler {
    @Override
    protected void processAction(ISelectionProvider selectionProvider, ICommentsSupport commentsSupport, IDocument document, ITextSelection textSelection) throws BadLocationException {
        int originalLength;
        Object[] singleLineComments = commentsSupport.getSingleLineComments();
        if (ArrayUtils.isEmpty((Object[])singleLineComments)) {
            return;
        }
        int selOffset = textSelection.getOffset();
        int originalOffset = textSelection.getOffset();
        int selLength = originalLength = textSelection.getLength();
        DocumentRewriteSession rewriteSession = null;
        if (document instanceof IDocumentExtension4) {
            rewriteSession = ((IDocumentExtension4)document).startRewriteSession(DocumentRewriteSessionType.SEQUENTIAL);
        }
        int endLine = textSelection.getEndLine();
        int startLine = textSelection.getStartLine();
        boolean forceComment = true;
        String firstLineText = document.get(document.getLineOffset(startLine), document.getLineLength(startLine)).trim();
        for (Object commentString : singleLineComments) {
            if (!firstLineText.startsWith((String)commentString)) continue;
            forceComment = false;
            break;
        }
        for (int lineNum = endLine; lineNum >= startLine; --lineNum) {
            int lineOffset = document.getLineOffset(lineNum);
            int lineLength = document.getLineLength(lineNum);
            if (forceComment) {
                document.replace(lineOffset, 0, (String)singleLineComments[0]);
                if (lineNum == startLine) {
                    selOffset += ((String)singleLineComments[0]).length();
                    continue;
                }
                selLength += ((String)singleLineComments[0]).length();
                continue;
            }
            Object lineComment = null;
            String lineText = document.get(lineOffset, lineLength);
            int checkOffset = 0;
            for (int i = 0; i < lineText.length() && Character.isWhitespace(lineText.charAt(i)); ++i) {
                ++checkOffset;
            }
            for (Object commentString : singleLineComments) {
                if (!lineText.startsWith((String)commentString, checkOffset)) continue;
                lineComment = commentString;
                break;
            }
            if (lineComment == null) continue;
            document.replace(lineOffset + checkOffset, ((String)lineComment).length(), "");
            if (lineNum == startLine && originalOffset != lineOffset) {
                selOffset = Math.max(lineOffset, originalOffset - ((String)lineComment).length());
                if (((String)lineComment).length() + lineOffset <= originalOffset) continue;
                selLength -= ((String)lineComment).length() - originalOffset + lineOffset;
                continue;
            }
            selOffset = lineOffset;
            selLength -= ((String)lineComment).length();
        }
        if (rewriteSession != null) {
            ((IDocumentExtension4)document).stopRewriteSession(rewriteSession);
        }
        if (originalLength > 0) {
            selectionProvider.setSelection((ISelection)new TextSelection(selOffset, selLength));
        }
    }
}

