/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.team.git.ui.handlers;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.egit.ui.internal.sharing.SharingWizard;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBPMessageType;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.DBeaverNotifications;
import org.jkiss.dbeaver.team.git.ui.internal.GITMessages;
import org.jkiss.dbeaver.team.git.ui.utils.GitUIUtils;
import org.jkiss.dbeaver.ui.ActionUtils;
import org.jkiss.dbeaver.ui.UIUtils;

public class ProjectShareHandler
extends AbstractHandler
implements IElementUpdater {
    private static final Log log = Log.getLog(ProjectShareHandler.class);

    public Object execute(ExecutionEvent event) {
        IProject project = GitUIUtils.extractActiveProject(event);
        if (project == null) {
            DBWorkbench.getPlatformUI().showError("Nothing to share - no active project", "Select a project or resource to share");
            return null;
        }
        IWorkbench workbench = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event).getWorkbench();
        SharingWizard wizard = new SharingWizard();
        wizard.init(workbench, project);
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.setHelpAvailable(false);
        if (wizardDialog.open() == 0) {
            this.addProjectContentsToRepository(event, project);
            DBeaverNotifications.showNotification((String)"git.project.added", (String)GITMessages.project_share_handler_notifications_title_project_added, (String)NLS.bind((String)GITMessages.project_share_handler_notifications_text_project_added, (Object)project.getName()), (DBPMessageType)DBPMessageType.INFORMATION, () -> ActionUtils.runCommand((String)"org.jkiss.dbeaver.git.commands.commit", (IServiceLocator)workbench));
        }
        return null;
    }

    private void addProjectContentsToRepository(ExecutionEvent event, IProject project) {
        ArrayList<IResource> resources = new ArrayList<IResource>();
        try {
            this.addFolderToIndex((IContainer)project, resources);
        }
        catch (CoreException e) {
            log.error((Object)e);
        }
        StructuredSelection selection = new StructuredSelection(resources);
        ActionUtils.runCommand((String)"org.eclipse.egit.ui.team.AddToIndex", (ISelection)selection, (IServiceLocator)UIUtils.getActiveWorkbenchWindow());
    }

    private void addFolderToIndex(IContainer container, List<IResource> resources) throws CoreException {
        for (IResource resource : container.members(8)) {
            if (container instanceof IProject && resource instanceof IFolder && resource.getName().equals(".dbeaver")) {
                for (IResource cfgResource : ((IFolder)resource).members(8)) {
                    if (!(cfgResource instanceof IFile) || cfgResource.getFileExtension().equals("bak")) continue;
                    resources.add(cfgResource);
                }
                continue;
            }
            if (resource.isHidden() || resource.isTeamPrivateMember() || resource.isLinked() || resource.isVirtual() || !resource.exists() || container instanceof IProject && (resource instanceof IFolder && resource.getName().equals(".settings") || resource instanceof IFile && resource.getName().startsWith(".dbeaver-data-sources") && resource.getName().endsWith(".xml"))) continue;
            if (resource instanceof IFolder) {
                this.addFolderToIndex((IContainer)((IFolder)resource), resources);
                continue;
            }
            resources.add(resource);
        }
    }

    public void updateElement(UIElement element, Map parameters) {
        IProject project = GitUIUtils.extractActiveProject(element.getServiceLocator());
        if (project != null) {
            element.setText(NLS.bind((String)GITMessages.project_share_handler_menu_element_text_add, (Object)project.getName()));
        }
    }
}

