/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.team.git.ui.utils;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.services.IServiceLocator;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNProject;
import org.jkiss.dbeaver.model.navigator.DBNResource;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.editors.IDatabaseEditorInput;

public class GitUIUtils {
    public static IProject extractActiveProject(ExecutionEvent event) {
        IEditorPart activeEditor;
        IProject project = GitUIUtils.extractProject(HandlerUtil.getCurrentSelection((ExecutionEvent)event));
        if (project == null && (activeEditor = HandlerUtil.getActiveEditor((ExecutionEvent)event)) != null) {
            return GitUIUtils.extractProject(activeEditor);
        }
        return project;
    }

    public static IProject extractProject(ISelection selection) {
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object e = ss.getFirstElement();
            if (e instanceof DBNResource) {
                DBNResource resNode = (DBNResource)e;
                IResource resource = resNode.getResource();
                return resource == null ? null : resource.getProject();
            }
            if (e instanceof DBNNode) {
                DBNNode node;
                DBNNode n = node = (DBNNode)e;
                while (n != null) {
                    DBNProject projectNode;
                    DBPProject dBPProject;
                    if (n instanceof DBNProject && (dBPProject = (projectNode = (DBNProject)n).getProject()) instanceof RCPProject) {
                        RCPProject rcpProject = (RCPProject)dBPProject;
                        return rcpProject.getEclipseProject();
                    }
                    n = n.getParentNode();
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Nullable
    public static IProject extractProject(@NotNull IEditorPart activeEditor) {
        IEditorInput editorInput = activeEditor.getEditorInput();
        if (editorInput instanceof IDatabaseEditorInput) {
            DBPProject dBPProject;
            IDatabaseEditorInput dei = (IDatabaseEditorInput)editorInput;
            DBNDatabaseNode node = dei.getNavigatorNode();
            if (node != null && (dBPProject = node.getOwnerProject()) instanceof RCPProject) {
                RCPProject rcpProject = (RCPProject)dBPProject;
                return rcpProject.getEclipseProject();
            }
        } else {
            IFile input = EditorUtils.getFileFromInput((IEditorInput)editorInput);
            if (input != null) {
                return input.getProject();
            }
        }
        return null;
    }

    public static IProject extractActiveProject(IServiceLocator serviceLocator) {
        IWorkbenchWindow workbenchWindow;
        IWorkbenchWindow iWorkbenchWindow = workbenchWindow = serviceLocator == null ? null : (IWorkbenchWindow)serviceLocator.getService(IWorkbenchWindow.class);
        if (workbenchWindow == null || workbenchWindow.getActivePage() == null) {
            return null;
        }
        return GitUIUtils.extractActiveProject(workbenchWindow);
    }

    public static IProject extractActiveProject(IWorkbenchWindow window) {
        IWorkbenchPage activePage = window.getActivePage();
        if (activePage != null) {
            IProject project;
            ISelectionProvider selectionProvider;
            IWorkbenchPart activePart = activePage.getActivePart();
            if (activePart != null && (selectionProvider = activePart.getSite().getSelectionProvider()) != null && (project = GitUIUtils.extractProject(selectionProvider.getSelection())) != null) {
                return project;
            }
            IEditorPart activeEditor = activePage.getActiveEditor();
            if (activeEditor != null) {
                return GitUIUtils.extractProject(activeEditor);
            }
        }
        return null;
    }
}

