/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ext.wmi.model.WMIClass;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraint;
import org.jkiss.dbeaver.model.struct.DBSEntityConstraintType;

public class WMIClassInheritance
implements DBSEntityAssociation {
    private WMIClass superClass;
    private WMIClass subClass;

    public WMIClassInheritance(WMIClass superClass, WMIClass subClass) {
        this.superClass = superClass;
        this.subClass = subClass;
    }

    public boolean isPersisted() {
        return true;
    }

    @NotNull
    public String getName() {
        return this.subClass.getName() + " inherits " + this.superClass.getName();
    }

    @Nullable
    public String getDescription() {
        return null;
    }

    @NotNull
    public WMIClass getParentObject() {
        return this.subClass;
    }

    @NotNull
    public DBPDataSource getDataSource() {
        return this.subClass.getDataSource();
    }

    @Nullable
    public WMIClass getAssociatedEntity() {
        return this.superClass;
    }

    @NotNull
    public DBSEntityConstraintType getConstraintType() {
        return DBSEntityConstraintType.INHERITANCE;
    }

    @Nullable
    public DBSEntityConstraint getReferencedConstraint() {
        return this;
    }
}

