/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.wmi.service;

import java.util.ArrayList;
import java.util.List;
import org.jkiss.wmi.service.WMIException;
import org.jkiss.wmi.service.WMIObjectAttribute;
import org.jkiss.wmi.service.WMIObjectMethod;
import org.jkiss.wmi.service.WMIQualifiedObject;
import org.jkiss.wmi.service.WMIQualifier;

public class WMIObject
extends WMIQualifiedObject {
    private long objectHandle;

    public String getObjectText() throws WMIException {
        return this.readObjectText();
    }

    public Object getValue(String name) throws WMIException {
        return this.readAttributeValue(name);
    }

    public void setValue(String name, Object value) throws WMIException {
        this.writeAttributeValue(name, value);
    }

    public List<WMIObjectAttribute> getAttributes(long flags) throws WMIException {
        ArrayList<WMIObjectAttribute> attributes = new ArrayList<WMIObjectAttribute>();
        this.readAttributes(flags, attributes);
        return attributes;
    }

    public List<WMIObjectMethod> getMethods(long flags) throws WMIException {
        ArrayList<WMIObjectMethod> methods = new ArrayList<WMIObjectMethod>();
        this.readMethods(flags, methods);
        return methods;
    }

    public void release() {
        this.releaseObject();
    }

    protected void finalize() throws Throwable {
        this.releaseObject();
        super.finalize();
    }

    @Override
    protected void readObjectQualifiers(List<WMIQualifier> qualifiers) throws WMIException {
        this.readQualifiers(false, null, qualifiers);
    }

    public String toString() {
        return "WMIObject:" + this.objectHandle;
    }

    private native String readObjectText() throws WMIException;

    private native Object readAttributeValue(String var1) throws WMIException;

    private native void writeAttributeValue(String var1, Object var2) throws WMIException;

    private native void readAttributes(long var1, List<WMIObjectAttribute> var3) throws WMIException;

    private native void readMethods(long var1, List<WMIObjectMethod> var3) throws WMIException;

    native void readQualifiers(boolean var1, String var2, List<WMIQualifier> var3) throws WMIException;

    native void releaseObject();
}

