/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.wmi.model;

import java.util.Collection;
import java.util.Collections;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.wmi.model.WMIDataSourceInfo;
import org.jkiss.dbeaver.ext.wmi.model.WMIDialect;
import org.jkiss.dbeaver.ext.wmi.model.WMINamespace;
import org.jkiss.dbeaver.ext.wmi.model.WMISession;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPExclusiveResource;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCInvalidatePhase;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.impl.AbstractDataSource;
import org.jkiss.dbeaver.model.impl.AbstractExecutionContext;
import org.jkiss.dbeaver.model.impl.SimpleExclusiveLock;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.wmi.service.WMIService;

public class WMIDataSource
extends AbstractDataSource
implements DBSInstance,
DBCExecutionContext,
DBPAdaptable {
    private WMINamespace rootNamespace;
    private final SQLDialect dialect;
    private final long id;
    private final DBPExclusiveResource exclusiveLock = new SimpleExclusiveLock();

    public WMIDataSource(DBPDataSourceContainer container) {
        super(container);
        this.dialect = new WMIDialect();
        this.id = AbstractExecutionContext.generateContextId();
        QMUtils.getDefaultHandler().handleContextOpen((DBCExecutionContext)this, false);
    }

    @NotNull
    public DBPDataSourceInfo getInfo() {
        return new WMIDataSourceInfo();
    }

    @NotNull
    public DBCExecutionContext getDefaultContext(@NotNull DBRProgressMonitor monitor, boolean meta) {
        return this;
    }

    @NotNull
    public DBCExecutionContext[] getAllContexts() {
        return new DBCExecutionContext[]{this};
    }

    public long getContextId() {
        return this.id;
    }

    @NotNull
    public String getContextName() {
        return "WMI Data Source";
    }

    public DBSInstance getOwnerInstance() {
        return this;
    }

    public boolean isConnected() {
        return true;
    }

    @NotNull
    public DBCSession openSession(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionPurpose purpose, @NotNull String task) {
        return new WMISession(monitor, purpose, task, this);
    }

    public void checkContextAlive(DBRProgressMonitor monitor) throws DBException {
    }

    @NotNull
    public DBCExecutionContext openIsolatedContext(@NotNull DBRProgressMonitor monitor, @NotNull String purpose, @Nullable DBCExecutionContext initFrom) throws DBException {
        return this;
    }

    public void invalidateContext(@NotNull DBRProgressMonitor monitor, @NotNull DBCInvalidatePhase phase) throws DBException {
    }

    @Nullable
    public DBCExecutionContextDefaults getContextDefaults() {
        return null;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        DBPConnectionConfiguration connectionInfo = this.container.getActualConnectionConfiguration();
        try {
            WMIService service = WMIService.connect(connectionInfo.getServerName(), connectionInfo.getHostName(), connectionInfo.getUserName(), connectionInfo.getUserPassword(), null, connectionInfo.getDatabaseName());
            this.rootNamespace = new WMINamespace(null, this, connectionInfo.getDatabaseName(), service);
        }
        catch (UnsatisfiedLinkError e) {
            throw new DBException("Can't link with WMI native library", (Throwable)e);
        }
        catch (Throwable e) {
            throw new DBException("Can't connect to WMI service", e);
        }
    }

    public void close() {
        if (this.rootNamespace != null) {
            this.rootNamespace.close();
            if (this.rootNamespace.service != null) {
                this.rootNamespace.service.close();
            }
            this.rootNamespace = null;
        }
        QMUtils.getDefaultHandler().handleContextClose((DBCExecutionContext)this);
    }

    @NotNull
    public DBSInstance getDefaultInstance() {
        return this;
    }

    @NotNull
    public Collection<? extends DBSInstance> getAvailableInstances() {
        return Collections.singletonList(this);
    }

    public void shutdown(@NotNull DBRProgressMonitor monitor) {
        this.close();
    }

    @NotNull
    public DBPExclusiveResource getExclusiveLock() {
        return this.exclusiveLock;
    }

    @Association
    public Collection<WMINamespace> getNamespaces() {
        return Collections.singletonList(this.rootNamespace);
    }

    public WMIService getService() {
        return this.rootNamespace.service;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == DBSObjectContainer.class) {
            return adapter.cast(this.rootNamespace);
        }
        return null;
    }

    @NotNull
    public SQLDialect getSQLDialect() {
        return this.dialect;
    }
}

