/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.oracle.model;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBDatabaseException;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.ext.oracle.internal.OracleMessages;
import org.jkiss.dbeaver.ext.oracle.model.OracleAttributeContentTypeProvider;
import org.jkiss.dbeaver.ext.oracle.model.OracleChangeUserPasswordManager;
import org.jkiss.dbeaver.ext.oracle.model.OracleConfigurator;
import org.jkiss.dbeaver.ext.oracle.model.OracleDBLink;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataSourceInfo;
import org.jkiss.dbeaver.ext.oracle.model.OracleDataType;
import org.jkiss.dbeaver.ext.oracle.model.OracleExecutionContext;
import org.jkiss.dbeaver.ext.oracle.model.OracleGrantee;
import org.jkiss.dbeaver.ext.oracle.model.OracleRecycledObject;
import org.jkiss.dbeaver.ext.oracle.model.OracleRole;
import org.jkiss.dbeaver.ext.oracle.model.OracleSQLDialect;
import org.jkiss.dbeaver.ext.oracle.model.OracleSchema;
import org.jkiss.dbeaver.ext.oracle.model.OracleStructureAssistant;
import org.jkiss.dbeaver.ext.oracle.model.OracleSynonym;
import org.jkiss.dbeaver.ext.oracle.model.OracleTablespace;
import org.jkiss.dbeaver.ext.oracle.model.OracleUser;
import org.jkiss.dbeaver.ext.oracle.model.OracleUserProfile;
import org.jkiss.dbeaver.ext.oracle.model.OracleUtils;
import org.jkiss.dbeaver.ext.oracle.model.plan.OracleQueryPlanner;
import org.jkiss.dbeaver.ext.oracle.model.session.OracleServerSessionManager;
import org.jkiss.dbeaver.model.DBPAdaptable;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBPObjectStatisticsCollector;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.access.DBAPasswordChangeInfo;
import org.jkiss.dbeaver.model.access.DBAUserPasswordManager;
import org.jkiss.dbeaver.model.admin.sessions.DBAServerSessionManager;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.model.connection.DBPDriver;
import org.jkiss.dbeaver.model.data.DBDAttributeContentTypeProvider;
import org.jkiss.dbeaver.model.data.DBDPseudoAttribute;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeContainer;
import org.jkiss.dbeaver.model.data.DBDPseudoAttributeType;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionResult;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformType;
import org.jkiss.dbeaver.model.exec.DBCQueryTransformer;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCCallableStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCDatabaseMetaData;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.exec.output.DBCOutputWriter;
import org.jkiss.dbeaver.model.exec.output.DBCServerOutputReader;
import org.jkiss.dbeaver.model.exec.plan.DBCQueryPlanner;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCRemoteInstance;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCStructCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLState;
import org.jkiss.dbeaver.model.struct.DBSDataType;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectFilter;
import org.jkiss.dbeaver.model.struct.DBSStructureAssistant;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.BeanUtils;
import org.jkiss.utils.CommonUtils;

public class OracleDataSource
extends JDBCDataSource
implements DBPObjectStatisticsCollector,
DBPAdaptable,
DBDPseudoAttributeContainer {
    private static final Log log = Log.getLog(OracleDataSource.class);
    public static final DBDPseudoAttribute[] KNOWN_GLOBAL_PSEUDO_ATTRS = new DBDPseudoAttribute[]{new DBDPseudoAttribute(DBDPseudoAttributeType.ROWID, "rownum", null, null, OracleMessages.pseudo_column_rowid_description, true, DBDPseudoAttribute.PropagationPolicy.ROWSET_LOCAL)};
    public final SchemaCache schemaCache = new SchemaCache();
    final DataTypeCache dataTypeCache = new DataTypeCache();
    final TablespaceCache tablespaceCache = new TablespaceCache();
    final UserCache userCache = new UserCache();
    final ProfileCache profileCache = new ProfileCache();
    final RoleCache roleCache = new RoleCache();
    private OracleOutputReader outputReader;
    private OracleSchema publicSchema;
    private boolean isAdmin;
    private boolean isAdminVisible;
    private String planTableName;
    private boolean useRuleHint;
    private boolean resolveGeometryAsStruct = true;
    private boolean hasStatistics;
    private boolean isPasswordExpireWarningShown;
    private final Map<String, Boolean> availableViews = new HashMap<String, Boolean>();
    private static final Pattern ERROR_POSITION_PATTERN = Pattern.compile(".+\\s+line ([0-9]+), column ([0-9]+)");
    private static final Pattern ERROR_POSITION_PATTERN_2 = Pattern.compile(".+\\s+at line ([0-9]+)");
    private static final Pattern ERROR_POSITION_PATTERN_3 = Pattern.compile(".+\\s+at position\\: ([0-9]+)");

    public OracleDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container) throws DBException {
        super(monitor, container, (SQLDialect)new OracleSQLDialect());
        this.init();
    }

    public OracleDataSource(@NotNull DBRProgressMonitor monitor, @NotNull DBPDataSourceContainer container, @NotNull OracleSQLDialect dialect) throws DBException {
        super(monitor, container, (SQLDialect)dialect);
        this.init();
    }

    public OracleDataSource(@NotNull DBPDataSourceContainer container) {
        super(container, (SQLDialect)new OracleSQLDialect());
        this.init();
        this.hasStatistics = false;
        OracleSchema defSchema = new OracleSchema(this, -1L, "TEST_SCHEMA");
        this.schemaCache.setCache(Collections.singletonList(defSchema));
    }

    private void init() {
        this.outputReader = new OracleOutputReader();
        OracleConfigurator configurator = (OracleConfigurator)GeneralUtils.adapt((Object)((Object)this), OracleConfigurator.class);
        if (configurator != null) {
            this.resolveGeometryAsStruct = configurator.resolveGeometryAsStruct();
        }
    }

    @NotNull
    OracleSchema getPublicSchema() {
        return this.publicSchema;
    }

    @NotNull
    public UserCache getUserCache() {
        return this.userCache;
    }

    public Object getDataSourceFeature(String featureId) {
        switch (featureId) {
            case "datasource.max-string-type-length": {
                return 4000;
            }
        }
        return super.getDataSourceFeature(featureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isViewAvailable(@NotNull DBRProgressMonitor monitor, @Nullable String schemaName, @NotNull String viewName) {
        Boolean available;
        viewName = viewName.toUpperCase();
        Map<String, Boolean> map = this.availableViews;
        synchronized (map) {
            available = this.availableViews.get(viewName);
        }
        if (available == null) {
            try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Check view existence");){
                String viewNameQuoted = DBUtils.getQuotedIdentifier((DBPDataSource)this, (String)viewName);
                try (JDBCPreparedStatement dbStat = session.prepareStatement("SELECT 1 FROM " + (String)(schemaName == null ? viewNameQuoted : DBUtils.getQuotedIdentifier((DBPDataSource)this, (String)schemaName) + "." + viewNameQuoted) + " WHERE 1<>1");){
                    dbStat.setFetchSize(1);
                    dbStat.execute();
                    available = true;
                }
            }
            catch (Exception e) {
                available = false;
            }
            map = this.availableViews;
            synchronized (map) {
                this.availableViews.put(viewName, available);
            }
        }
        return available;
    }

    protected Connection openConnection(@NotNull DBRProgressMonitor monitor, @Nullable JDBCExecutionContext context, @NotNull String purpose) throws DBCException {
        try {
            Connection connection = super.openConnection(monitor, context, purpose);
            try {
                for (SQLWarning warninig = connection.getWarnings(); warninig != null && !this.isPasswordExpireWarningShown; warninig = warninig.getNextWarning()) {
                    if (!this.checkForPasswordWillExpireWarning(warninig)) continue;
                    this.isPasswordExpireWarningShown = true;
                }
            }
            catch (SQLException e) {
                log.debug((Object)"Can't get connection warnings", (Throwable)e);
            }
            return connection;
        }
        catch (DBCException e) {
            if (SQLState.getCodeFromException((Throwable)e) == 28001 && this.changeExpiredPassword(monitor, context, purpose)) {
                return this.openConnection(monitor, context, purpose);
            }
            throw e;
        }
    }

    private boolean checkForPasswordWillExpireWarning(@NotNull SQLWarning warning) {
        if (warning != null && warning.getErrorCode() == 28002) {
            DBWorkbench.getPlatformUI().showWarningMessageBox(OracleMessages.oracle_password_will_expire_warn_name, NLS.bind((String)OracleMessages.oracle_password_will_expire_warn_description, (Object)warning.getMessage()));
            return true;
        }
        return false;
    }

    private boolean changeExpiredPassword(DBRProgressMonitor monitor, JDBCExecutionContext context, String purpose) {
        DBPConnectionConfiguration connectionInfo = this.getContainer().getActualConnectionConfiguration();
        DBAPasswordChangeInfo passwordInfo = DBWorkbench.getPlatformUI().promptUserPasswordChange("Password has expired. Set new password.", connectionInfo.getUserName(), connectionInfo.getUserPassword(), true, true);
        if (passwordInfo == null) {
            return false;
        }
        try {
            if (passwordInfo.getNewPassword() == null) {
                throw new DBException("You can't set empty password");
            }
            Properties connectProps = this.getAllConnectionProperties(monitor, context, purpose, connectionInfo);
            connectProps.setProperty("user", passwordInfo.getUserName());
            connectProps.setProperty("password", passwordInfo.getOldPassword());
            connectProps.setProperty("oracle.jdbc.newPassword", passwordInfo.getNewPassword());
            String url = this.getConnectionURL(connectionInfo);
            monitor.subTask("Connecting for expired password change");
            Driver driverInstance = this.getDriverInstance(monitor);
            try (Connection connection = driverInstance.connect(url, connectProps);){
                if (connection == null) {
                    throw new DBCException("Null connection returned");
                }
            }
            connectionInfo.setUserPassword(passwordInfo.getNewPassword());
            this.getContainer().getConnectionConfiguration().setUserPassword(passwordInfo.getNewPassword());
            this.getContainer().persistConfiguration();
            return true;
        }
        catch (Exception e) {
            DBWorkbench.getPlatformUI().showError("Error changing password", "Error changing expired password", (Throwable)e);
            return false;
        }
    }

    protected JDBCExecutionContext createExecutionContext(JDBCRemoteInstance instance, String type) {
        return new OracleExecutionContext(instance, type);
    }

    protected void initializeContextState(@NotNull DBRProgressMonitor monitor, @NotNull JDBCExecutionContext context, JDBCExecutionContext initFrom) throws DBException {
        if (this.outputReader == null) {
            this.outputReader = new OracleOutputReader();
        }
        this.outputReader.enableServerOutput(monitor, (DBCExecutionContext)context, this.outputReader.isServerOutputEnabled());
        if (initFrom != null) {
            ((OracleExecutionContext)context).setCurrentSchema(monitor, ((OracleExecutionContext)initFrom).getDefaultSchema());
        } else {
            ((OracleExecutionContext)context).refreshDefaults(monitor, true);
        }
        DBPConnectionConfiguration connectionInfo = this.getContainer().getConnectionConfiguration();
        try (JDBCSession session = context.openSession(monitor, DBCExecutionPurpose.META, "Set connection parameters");){
            boolean isMetadataContext;
            String sessionTerritory;
            try {
                this.readDatabaseServerVersion((Connection)session, (DatabaseMetaData)session.getMetaData());
            }
            catch (SQLException e) {
                log.debug((Object)"Error reading metadata", (Throwable)e);
            }
            LinkedHashMap<String, String> paramsMap = new LinkedHashMap<String, String>();
            String sessionLanguage = connectionInfo.getProviderProperty("@dbeaver-session-language@");
            if (sessionLanguage != null) {
                paramsMap.put("NLS_LANGUAGE", "'" + sessionLanguage + "'");
            }
            if ((sessionTerritory = connectionInfo.getProviderProperty("@dbeaver-session-territory@")) != null) {
                paramsMap.put("NLS_TERRITORY", "'" + sessionTerritory + "'");
            }
            this.setNLSParameter(paramsMap, connectionInfo, "NLS_DATE_FORMAT", "@dbeaver-session-nls-date-format@");
            this.setNLSParameter(paramsMap, connectionInfo, "NLS_TIMESTAMP_FORMAT", "session-nls-timestamp-format");
            this.setNLSParameter(paramsMap, connectionInfo, "NLS_LENGTH_SEMANTICS", "session-nls-length-format");
            this.setNLSParameter(paramsMap, connectionInfo, "NLS_CURRENCY", "session-nls-currency-format");
            ModelPreferences.SeparateConnectionBehavior behavior = ModelPreferences.SeparateConnectionBehavior.parse((String)this.getContainer().getPreferenceStore().getString("database.meta.separate.connection"));
            boolean isMetaConnectionSeparate = switch (behavior) {
                case ModelPreferences.SeparateConnectionBehavior.ALWAYS -> true;
                case ModelPreferences.SeparateConnectionBehavior.NEVER -> false;
                default -> !this.container.isForceUseSingleConnection();
            };
            boolean bl = isMetadataContext = isMetaConnectionSeparate ? "Metadata".equals(context.getContextName()) : "Main".equals(context.getContextName());
            if (isMetadataContext && CommonUtils.getBoolean((String)connectionInfo.getProviderProperty("@dbeaver-use-meta-optimizer@"), (boolean)this.getContainer().getPreferenceStore().getBoolean("@dbeaver-use-meta-optimizer@"))) {
                paramsMap.put("\"_optimizer_push_pred_cost_based\"", "FALSE");
                paramsMap.put("\"_optimizer_squ_bottomup\"", "FALSE");
                paramsMap.put("\"_optimizer_cost_based_transformation\"", "'OFF'");
                String optimizerVersion = connectionInfo.getProviderProperty("oracle-meta-optimizer-version");
                if (CommonUtils.isEmpty((String)optimizerVersion) && this.isServerVersionAtLeast(10, 2)) {
                    optimizerVersion = "10.2.0.5";
                }
                if (!CommonUtils.isEmpty((String)optimizerVersion)) {
                    paramsMap.put("OPTIMIZER_FEATURES_ENABLE", "'" + optimizerVersion + "'");
                }
            }
            if (!paramsMap.isEmpty()) {
                StringBuilder query = new StringBuilder("ALTER SESSION SET ");
                for (Map.Entry pe : paramsMap.entrySet()) {
                    query.append(" ").append((String)pe.getKey()).append("=").append((String)pe.getValue());
                }
                try {
                    JDBCUtils.executeQuery((Connection)session, (String)query.toString(), (Object[])new Object[0]);
                }
                catch (SQLException e) {
                    log.error((Object)"Error settings Oracle session parameters", (Throwable)e);
                }
            }
        }
    }

    private void setNLSParameter(Map<String, String> paramsMap, DBPConnectionConfiguration connectionInfo, String oraNlsName, String paramName) {
        String paramValue = connectionInfo.getProviderProperty(paramName);
        if (!CommonUtils.isEmpty((String)paramValue)) {
            paramsMap.put(oraNlsName, "'" + paramValue + "'");
        }
    }

    public OracleSchema getDefaultSchema() {
        return (OracleSchema)DBUtils.getDefaultContext((DBSObject)this, (boolean)true).getContextDefaults().getDefaultSchema();
    }

    protected DBPDataSourceInfo createDataSourceInfo(DBRProgressMonitor monitor, @NotNull JDBCDatabaseMetaData metaData) {
        return new OracleDataSourceInfo(metaData);
    }

    @NotNull
    public DBPErrorAssistant.ErrorType discoverErrorType(@NotNull Throwable error) {
        Throwable rootCause = CommonUtils.getRootCause((Throwable)error);
        if (rootCause instanceof SQLException) {
            SQLException sqlException = (SQLException)rootCause;
            switch (sqlException.getErrorCode()) {
                case 17283: {
                    return DBPErrorAssistant.ErrorType.RESULT_SET_MISSING;
                }
                case 17023: {
                    return DBPErrorAssistant.ErrorType.FEATURE_UNSUPPORTED;
                }
                case 1017: {
                    return DBPErrorAssistant.ErrorType.AUTHENTICATION_FAILED;
                }
            }
        }
        return super.discoverErrorType(error);
    }

    protected Map<String, String> getInternalConnectionProperties(@NotNull DBRProgressMonitor monitor, @NotNull DBPDriver driver, @NotNull JDBCExecutionContext context, @NotNull String purpose, @NotNull DBPConnectionConfiguration connectionInfo) throws DBCException {
        HashMap<String, String> connectionsProps = new HashMap<String, String>();
        if (!this.getContainer().getPreferenceStore().getBoolean("database.meta.client.name.disable")) {
            String appName = DBUtils.getClientApplicationName((DBPDataSourceContainer)this.getContainer(), (DBCExecutionContext)context, (String)purpose);
            appName = appName.replaceAll("[^ a-zA-Z0-9]", "?");
            connectionsProps.put("v$session.program", CommonUtils.truncateString((String)appName, (int)48));
        }
        if (CommonUtils.toBoolean((Object)connectionInfo.getProviderProperty("@dbeaver-os-authentication@"))) {
            connectionsProps.put("v$session.osuser", System.getProperty("user.name"));
        }
        return connectionsProps;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isAdminVisible() {
        return this.isAdmin || this.isAdminVisible;
    }

    public boolean isUseRuleHint() {
        return this.useRuleHint;
    }

    @Association
    public Collection<OracleSchema> getSchemas(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.schemaCache.getAllObjects(monitor, (DBSObject)this);
    }

    public OracleSchema getSchema(DBRProgressMonitor monitor, String name) throws DBException {
        if (this.publicSchema != null && this.publicSchema.getName().equals(name)) {
            return this.publicSchema;
        }
        return this.schemaCache == null ? null : (OracleSchema)this.schemaCache.getObject(monitor, (DBSObject)this, name);
    }

    public OracleSchema createSchemaImpl(@NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) {
        return new OracleSchema(owner, (ResultSet)resultSet);
    }

    @Association
    public Collection<OracleTablespace> getTablespaces(DBRProgressMonitor monitor) throws DBException {
        return this.tablespaceCache.getAllObjects(monitor, (DBSObject)this);
    }

    public TablespaceCache getTablespaceCache() {
        return this.tablespaceCache;
    }

    @Association
    public Collection<OracleUser> getUsers(DBRProgressMonitor monitor) throws DBException {
        return this.userCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public OracleUser getUser(DBRProgressMonitor monitor, String name) throws DBException {
        return (OracleUser)this.userCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<OracleUserProfile> getProfiles(DBRProgressMonitor monitor) throws DBException {
        return this.profileCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<OracleRole> getRoles(DBRProgressMonitor monitor) throws DBException {
        return this.roleCache.getAllObjects(monitor, (DBSObject)this);
    }

    public OracleGrantee getGrantee(DBRProgressMonitor monitor, String name) throws DBException {
        OracleUser user = (OracleUser)this.userCache.getObject(monitor, (DBSObject)this, name);
        if (user != null) {
            return user;
        }
        return (OracleGrantee)this.roleCache.getObject(monitor, (DBSObject)this, name);
    }

    @Association
    public Collection<OracleSynonym> getPublicSynonyms(DBRProgressMonitor monitor) throws DBException {
        return this.publicSchema.getSynonyms(monitor);
    }

    @Association
    public Collection<OracleDBLink> getPublicDatabaseLinks(DBRProgressMonitor monitor) throws DBException {
        return this.publicSchema.getDatabaseLinks(monitor);
    }

    @Association
    public Collection<OracleRecycledObject> getUserRecycledObjects(DBRProgressMonitor monitor) throws DBException {
        return this.publicSchema.getRecycledObjects(monitor);
    }

    public boolean isAtLeastV9() {
        return this.getInfo().getDatabaseVersion().getMajor() >= 9;
    }

    public boolean isAtLeastV10() {
        return this.getInfo().getDatabaseVersion().getMajor() >= 10;
    }

    public boolean isAtLeastV11() {
        return this.getInfo().getDatabaseVersion().getMajor() >= 11;
    }

    public boolean isAtLeastV12() {
        return this.getInfo().getDatabaseVersion().getMajor() >= 12;
    }

    public void initialize(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.initialize(monitor);
        DBPConnectionConfiguration connectionInfo = this.getContainer().getConnectionConfiguration();
        String useRuleHintProp = connectionInfo.getProviderProperty("@dbeaver-use-rule-hint@");
        if (useRuleHintProp != null) {
            this.useRuleHint = CommonUtils.getBoolean((String)useRuleHintProp, (boolean)false);
        }
        this.publicSchema = new OracleSchema(this, 1L, "PUBLIC");
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)"Load data source meta info");){
            String showAdmin;
            this.isAdminVisible = this.isAdmin = "YES".equals(JDBCUtils.queryString((Connection)session, (String)"SELECT 'YES' FROM USER_ROLE_PRIVS WHERE GRANTED_ROLE='DBA'", (Object[])new Object[0]));
            if (!this.isAdminVisible && (showAdmin = connectionInfo.getProviderProperty("@dbeaver-always-show-dba@")) != null) {
                this.isAdminVisible = CommonUtils.getBoolean((String)showAdmin, (boolean)false);
            }
        }
        catch (SQLException e) {
            log.warn((Object)e);
        }
        this.dataTypeCache.setCaseSensitive(false);
        ArrayList<OracleDataType> dtList = new ArrayList<OracleDataType>();
        for (Map.Entry<String, OracleDataType.TypeDesc> predefinedType : OracleDataType.PREDEFINED_TYPES.entrySet()) {
            OracleDataType.TypeDesc typeDesc = predefinedType.getValue();
            if (!this.isServerVersionAtLeast(typeDesc.serverAtLeastMajor, typeDesc.serverAtLeastMinor)) continue;
            OracleDataType dataType = new OracleDataType((DBSObject)this, predefinedType.getKey(), true);
            dtList.add(dataType);
        }
        this.dataTypeCache.setCache(dtList);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        super.refreshObject(monitor);
        this.schemaCache.clearCache();
        this.tablespaceCache.clearCache();
        this.userCache.clearCache();
        this.profileCache.clearCache();
        this.roleCache.clearCache();
        this.hasStatistics = false;
        this.initialize(monitor);
        return this;
    }

    @Nullable
    public Collection<OracleSchema> getChildren(@NotNull DBRProgressMonitor monitor) throws DBException {
        return this.getSchemas(monitor);
    }

    public OracleSchema getChild(@NotNull DBRProgressMonitor monitor, @NotNull String childName) throws DBException {
        return this.getSchema(monitor, childName);
    }

    @NotNull
    public Class<? extends OracleSchema> getPrimaryChildType(@Nullable DBRProgressMonitor monitor) throws DBException {
        return OracleSchema.class;
    }

    public void cacheStructure(@NotNull DBRProgressMonitor monitor, int scope) throws DBException {
    }

    @Nullable
    public <T> T getAdapter(@NotNull Class<T> adapter) {
        if (adapter == DBSStructureAssistant.class) {
            return adapter.cast(new OracleStructureAssistant(this));
        }
        if (adapter == DBCServerOutputReader.class) {
            return adapter.cast(this.outputReader);
        }
        if (adapter == DBAServerSessionManager.class) {
            return adapter.cast(new OracleServerSessionManager(this));
        }
        if (adapter == DBCQueryPlanner.class) {
            return adapter.cast((Object)new OracleQueryPlanner(this));
        }
        if (adapter == DBAUserPasswordManager.class) {
            return adapter.cast(new OracleChangeUserPasswordManager(this));
        }
        if (adapter == DBDAttributeContentTypeProvider.class) {
            return adapter.cast(OracleAttributeContentTypeProvider.INSTANCE);
        }
        return (T)super.getAdapter(adapter);
    }

    public void cancelStatementExecute(DBRProgressMonitor monitor, JDBCStatement statement) throws DBException {
        if (this.driverSupportsQueryCancel()) {
            super.cancelStatementExecute(monitor, statement);
        } else {
            try {
                Connection connection = statement.getConnection().getOriginal();
                BeanUtils.invokeObjectMethod((Object)connection, (String)"cancel");
            }
            catch (Throwable e) {
                throw new DBDatabaseException("Can't cancel session queries", e, (DBPDataSource)this);
            }
        }
    }

    public boolean cancelCurrentExecution(@NotNull Connection connection, @Nullable Thread connectionThread) throws DBException {
        try {
            BeanUtils.invokeObjectMethod((Object)connection, (String)"cancel");
            return true;
        }
        catch (Throwable e) {
            throw new DBDatabaseException("Can't cancel session queries", e, (DBPDataSource)this);
        }
    }

    private boolean driverSupportsQueryCancel() {
        return true;
    }

    @NotNull
    public DBPDataKind resolveDataKind(@NotNull String typeName, int valueType) {
        if (typeName.equals("XMLTYPE") || typeName.equals("SYS.XMLTYPE")) {
            return DBPDataKind.CONTENT;
        }
        if (typeName.equals("PUBLIC.SDO_GEOMETRY") || typeName.equals("MDSYS.SDO_GEOMETRY")) {
            return this.resolveGeometryAsStruct ? DBPDataKind.STRUCT : DBPDataKind.OBJECT;
        }
        DBPDataKind dataKind = OracleDataType.getDataKind(typeName);
        if (dataKind != null) {
            return dataKind;
        }
        return super.resolveDataKind(typeName, valueType);
    }

    @NotNull
    public Collection<? extends DBSDataType> getLocalDataTypes() {
        return this.dataTypeCache.getCachedObjects();
    }

    @Nullable
    public OracleDataType getLocalDataType(String typeName) {
        return (OracleDataType)this.dataTypeCache.getCachedObject(typeName);
    }

    public DataTypeCache getDataTypeCache() {
        return this.dataTypeCache;
    }

    @Nullable
    public OracleDataType resolveDataType(@NotNull DBRProgressMonitor monitor, @NotNull String typeFullName) throws DBException {
        int divPos = typeFullName.indexOf(46);
        if (divPos == -1) {
            return this.getLocalDataType(typeFullName);
        }
        String schemaName = typeFullName.substring(0, divPos);
        String typeName = typeFullName.substring(divPos + 1);
        OracleSchema schema = this.getSchema(monitor, schemaName);
        if (schema == null) {
            return null;
        }
        return schema.getDataType(monitor, typeName);
    }

    @Nullable
    public String getPlanTableName(JDBCSession session) throws DBException {
        if (this.planTableName == null) {
            String tableName = this.getContainer().getPreferenceStore().getString("oracle.explain.table");
            String[] candidateNames = !CommonUtils.isEmpty((String)tableName) ? new String[]{tableName} : new String[]{"PLAN_TABLE", "TOAD_PLAN_TABLE"};
            for (String candidate : candidateNames) {
                try {
                    JDBCUtils.executeSQL((Connection)session, (String)("SELECT 1 FROM " + candidate), (Object[])new Object[0]);
                }
                catch (SQLException e) {
                    continue;
                }
                this.planTableName = candidate;
                break;
            }
            if (this.planTableName == null) {
                String newPlanTableName = candidateNames[0];
                if (!DBWorkbench.getPlatformUI().confirmAction("Oracle PLAN_TABLE missing", "PLAN_TABLE not found in current user's session. Do you want DBeaver to create new PLAN_TABLE (" + newPlanTableName + ")?")) {
                    return null;
                }
                this.planTableName = this.createPlanTable(session, newPlanTableName);
            }
        }
        return this.planTableName;
    }

    private String createPlanTable(JDBCSession session, String tableName) throws DBException {
        try {
            JDBCUtils.executeSQL((Connection)session, (String)"create global temporary table ${TABLE_NAME} (\nstatement_id varchar2(30),\nplan_id number,\ntimestamp date,\nremarks varchar2(4000),\noperation varchar2(30),\noptions varchar2(255),\nobject_node varchar2(128),\nobject_owner varchar2(30),\nobject_name varchar2(30),\nobject_alias varchar2(65),\nobject_instance numeric,\nobject_type varchar2(30),\noptimizer varchar2(255),\nsearch_columns number,\nid numeric,\nparent_id numeric,\ndepth numeric,\nposition numeric,\ncost numeric,\ncardinality numeric,\nbytes numeric,\nother_tag varchar2(255),\npartition_start varchar2(255),\npartition_stop varchar2(255),\npartition_id numeric,\nother long,\ndistribution varchar2(30),\ncpu_cost numeric,\nio_cost numeric,\ntemp_space numeric,\naccess_predicates varchar2(4000),\nfilter_predicates varchar2(4000),\nprojection varchar2(4000),\ntime numeric,\nqblock_name varchar2(30),\nother_xml clob\n) on commit preserve rows".replace("${TABLE_NAME}", tableName), (Object[])new Object[0]);
        }
        catch (SQLException e) {
            throw new DBDatabaseException("Error creating PLAN table", (Throwable)e, (DBPDataSource)this);
        }
        return tableName;
    }

    @Nullable
    public DBCQueryTransformer createQueryTransformer(@NotNull DBCQueryTransformType type) {
        if (type == DBCQueryTransformType.RESULT_SET_LIMIT) {
            // empty if block
        }
        return super.createQueryTransformer(type);
    }

    @Nullable
    public DBPErrorAssistant.ErrorPosition[] getErrorPosition(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @NotNull String query, @NotNull Throwable error) {
        block32: {
            while (error instanceof DBException && error.getCause() != null) {
                error = error.getCause();
            }
            String message = error.getMessage();
            if (!CommonUtils.isEmpty((String)message)) {
                DBPErrorAssistant.ErrorPosition pos;
                ArrayList<DBPErrorAssistant.ErrorPosition> positions = new ArrayList<DBPErrorAssistant.ErrorPosition>();
                Matcher matcher = ERROR_POSITION_PATTERN.matcher(message);
                while (matcher.find()) {
                    pos = new DBPErrorAssistant.ErrorPosition();
                    pos.info = matcher.group(1);
                    pos.line = Integer.parseInt(matcher.group(1)) - 1;
                    pos.position = Integer.parseInt(matcher.group(2)) - 1;
                    positions.add(pos);
                }
                if (positions.isEmpty()) {
                    matcher = ERROR_POSITION_PATTERN_2.matcher(message);
                    while (matcher.find()) {
                        pos = new DBPErrorAssistant.ErrorPosition();
                        pos.info = matcher.group(1);
                        pos.line = Integer.parseInt(matcher.group(1)) - 1;
                        positions.add(pos);
                    }
                }
                if (positions.isEmpty()) {
                    matcher = ERROR_POSITION_PATTERN_3.matcher(message);
                    while (matcher.find()) {
                        pos = new DBPErrorAssistant.ErrorPosition();
                        pos.info = matcher.group(1);
                        pos.position = Integer.parseInt(matcher.group(1)) - 1;
                        positions.add(pos);
                    }
                }
                if (!positions.isEmpty()) {
                    return positions.toArray(new DBPErrorAssistant.ErrorPosition[positions.size()]);
                }
            }
            if (error.getCause() != null) {
                try {
                    Object errorPosition = BeanUtils.readObjectProperty((Object)error.getCause(), (String)"errorPosition");
                    if (errorPosition instanceof Number) {
                        DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                        pos.position = ((Number)errorPosition).intValue();
                        return new DBPErrorAssistant.ErrorPosition[]{pos};
                    }
                }
                catch (Exception errorPosition) {
                    // empty catch block
                }
            }
            if (error instanceof SQLException && SQLState.SQL_42000.getCode().equals(((SQLException)error).getSQLState())) {
                try (JDBCSession session = (JDBCSession)context.openSession(monitor, DBCExecutionPurpose.UTIL, "Extract last error position");){
                    DBPErrorAssistant.ErrorPosition[] errorPositionArray;
                    block31: {
                        int errorPos;
                        JDBCCallableStatement stat;
                        block29: {
                            DBPErrorAssistant.ErrorPosition[] errorPositionArray2;
                            block30: {
                                stat = session.prepareCall("declare\n  l_cursor integer default dbms_sql.open_cursor; \nbegin \n  begin \n  dbms_sql.parse(  l_cursor, ?, dbms_sql.native ); \n    exception \n      when others then ? := dbms_sql.last_error_position; \n    end; \n    dbms_sql.close_cursor( l_cursor );\nend;");
                                try {
                                    stat.setString(1, query);
                                    stat.registerOutParameter(2, 4);
                                    stat.execute();
                                    errorPos = stat.getInt(2);
                                    if (errorPos > 0) break block29;
                                    errorPositionArray2 = null;
                                    if (stat == null) break block30;
                                }
                                catch (Throwable throwable) {
                                    try {
                                        if (stat != null) {
                                            try {
                                                stat.close();
                                            }
                                            catch (Throwable throwable2) {
                                                throwable.addSuppressed(throwable2);
                                            }
                                        }
                                        throw throwable;
                                    }
                                    catch (SQLException e) {
                                        log.debug((Object)("Can't extract parse error info: " + e.getMessage()));
                                        break block32;
                                    }
                                }
                                stat.close();
                            }
                            return errorPositionArray2;
                        }
                        DBPErrorAssistant.ErrorPosition pos = new DBPErrorAssistant.ErrorPosition();
                        pos.position = errorPos;
                        errorPositionArray = new DBPErrorAssistant.ErrorPosition[]{pos};
                        if (stat == null) break block31;
                        stat.close();
                    }
                    return errorPositionArray;
                }
            }
        }
        return null;
    }

    public boolean supportsPartitionsCreation() {
        return CommonUtils.getBoolean((Object)this.getContainer().getDriver().getDriverParameter("supports-partitions-creation"), (boolean)false);
    }

    public boolean isStatisticsCollected() {
        return this.hasStatistics;
    }

    void resetStatistics() {
        this.hasStatistics = false;
    }

    public void collectObjectStatistics(@NotNull DBRProgressMonitor monitor, boolean totalSizeOnly, boolean forceRefresh) throws DBException {
        if (this.hasStatistics && !forceRefresh) {
            return;
        }
        try (JDBCSession session = (JDBCSession)DBUtils.openMetaSession((DBRProgressMonitor)monitor, (DBPDataSource)this, (String)("Load tablespace '" + this.getName() + "' statistics"));
             JDBCStatement dbStat = session.createStatement();
             JDBCResultSet dbResult = dbStat.executeQuery("SELECT\n\tTS.TABLESPACE_NAME, F.AVAILABLE_SPACE, S.USED_SPACE\nFROM\n\tSYS.DBA_TABLESPACES TS,\n\t(SELECT TABLESPACE_NAME, SUM(BYTES) AVAILABLE_SPACE FROM DBA_DATA_FILES GROUP BY TABLESPACE_NAME) F,\n\t(SELECT TABLESPACE_NAME, SUM(BYTES) USED_SPACE FROM DBA_SEGMENTS GROUP BY TABLESPACE_NAME) S\nWHERE\n\tF.TABLESPACE_NAME(+) = TS.TABLESPACE_NAME AND S.TABLESPACE_NAME(+) = TS.TABLESPACE_NAME");){
            while (dbResult.next()) {
                String tsName = dbResult.getString(1);
                OracleTablespace tablespace = (OracleTablespace)this.tablespaceCache.getObject(monitor, (DBSObject)this, tsName);
                if (tablespace == null) continue;
                tablespace.fetchSizes(dbResult);
            }
        }
        catch (SQLException e) {
            throw new DBDatabaseException("Can't read tablespace statistics", (Throwable)e, this.getDataSource());
        }
        finally {
            this.hasStatistics = true;
        }
    }

    @NotNull
    protected String getStandardSQLDataTypeName(@NotNull DBPDataKind dataKind) {
        switch (dataKind) {
            case BOOLEAN: {
                return "BOOLEAN";
            }
            case NUMERIC: {
                return "NUMERIC";
            }
            case DATETIME: {
                return "TIMESTAMP";
            }
            case BINARY: 
            case CONTENT: {
                return "BLOB";
            }
            case ROWID: {
                return "ROWID";
            }
        }
        return "VARCHAR2";
    }

    public DBDPseudoAttribute[] getPseudoAttributes() throws DBException {
        return DBDPseudoAttribute.EMPTY_ARRAY;
    }

    public DBDPseudoAttribute[] getAllPseudoAttributes(@NotNull DBRProgressMonitor monitor) throws DBException {
        return KNOWN_GLOBAL_PSEUDO_ATTRS;
    }

    public boolean supportsUserEdit() {
        return false;
    }

    public boolean supportsSchedulerJobEdit() {
        return false;
    }

    static class SchemaCache
    extends JDBCObjectCache<OracleDataSource, OracleSchema> {
        SchemaCache() {
            this.setListOrderComparator(DBUtils.nameComparator());
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            StringBuilder schemasQuery = new StringBuilder();
            DBPConnectionConfiguration configuration = owner.getContainer().getConnectionConfiguration();
            boolean showOnlyOneSchema = CommonUtils.toBoolean((Object)configuration.getProviderProperty("show-only-one-schema@"));
            boolean showAllSchemas = !showOnlyOneSchema && !CommonUtils.toBoolean((Object)configuration.getProviderProperty("@dbeaver-check-schema-content@"));
            schemasQuery.append("SELECT U.* FROM ").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner, "USERS")).append(" U\n");
            schemasQuery.append("WHERE (");
            if (showOnlyOneSchema) {
                schemasQuery.append("(U.USERNAME) = ?");
            } else if (showAllSchemas) {
                schemasQuery.append("U.USERNAME IS NOT NULL");
            } else {
                schemasQuery.append("U.USERNAME IN (SELECT DISTINCT OWNER FROM ").append(OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner, "OBJECTS")).append(")");
            }
            DBSObjectFilter schemaFilters = owner.getContainer().getObjectFilter(OracleSchema.class, null, false);
            if (!showOnlyOneSchema && schemaFilters != null) {
                JDBCUtils.appendFilterClause((StringBuilder)schemasQuery, (DBSObjectFilter)schemaFilters, (String)"U.USERNAME", (boolean)false, (DBPDataSource)owner);
            }
            schemasQuery.append(")");
            JDBCPreparedStatement dbStat = session.prepareStatement(schemasQuery.toString());
            if (showOnlyOneSchema) {
                String userName = configuration.getUserName();
                if (CommonUtils.isEmpty((String)userName)) {
                    userName = JDBCUtils.queryString((Connection)session, (String)"SELECT SYS_CONTEXT('USERENV', 'SESSION_USER') FROM DUAL", (Object[])new Object[0]);
                }
                if (!CommonUtils.isEmpty((String)userName)) {
                    dbStat.setString(1, DBUtils.getUnQuotedIdentifier((DBPDataSource)owner, (String)userName.toUpperCase(Locale.ENGLISH)));
                }
            } else if (schemaFilters != null) {
                JDBCUtils.setFilterParameters((PreparedStatement)dbStat, (int)1, (DBSObjectFilter)schemaFilters);
            }
            return dbStat;
        }

        protected OracleSchema fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return owner.createSchemaImpl(owner, resultSet);
        }

        protected void invalidateObjects(DBRProgressMonitor monitor, OracleDataSource owner, Iterator<OracleSchema> objectIter) {
            this.setListOrderComparator(DBUtils.nameComparator());
        }
    }

    static class DataTypeCache
    extends JDBCObjectCache<OracleDataSource, OracleDataType> {
        DataTypeCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT " + OracleUtils.getSysCatalogHint(owner) + " * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner, "TYPES") + " WHERE OWNER IS NULL ORDER BY TYPE_NAME");
        }

        protected OracleDataType fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleDataType((DBSObject)owner, (ResultSet)resultSet);
        }
    }

    static class TablespaceCache
    extends JDBCObjectCache<OracleDataSource, OracleTablespace> {
        TablespaceCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM " + OracleUtils.getSysUserViewName(session.getProgressMonitor(), owner, "TABLESPACES") + " ORDER BY TABLESPACE_NAME");
        }

        protected OracleTablespace fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleTablespace(owner, (ResultSet)resultSet);
        }
    }

    static class UserCache
    extends JDBCObjectCache<OracleDataSource, OracleUser> {
        UserCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM " + OracleUtils.getAdminAllViewPrefix(session.getProgressMonitor(), owner, "USERS") + " ORDER BY USERNAME");
        }

        protected OracleUser fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleUser(owner, (ResultSet)resultSet);
        }
    }

    static class ProfileCache
    extends JDBCStructCache<OracleDataSource, OracleUserProfile, OracleUserProfile.ProfileResource> {
        protected ProfileCache() {
            super((Object)"PROFILE");
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT DISTINCT PROFILE FROM DBA_PROFILES ORDER BY PROFILE");
        }

        protected OracleUserProfile fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleUserProfile(owner, (ResultSet)resultSet);
        }

        protected JDBCStatement prepareChildrenStatement(@NotNull JDBCSession session, @NotNull OracleDataSource dataSource, @Nullable OracleUserProfile forObject) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT RESOURCE_NAME,RESOURCE_TYPE,LIMIT FROM DBA_PROFILES " + (forObject == null ? "" : "WHERE PROFILE=? ") + "ORDER BY RESOURCE_NAME");
            if (forObject != null) {
                dbStat.setString(1, forObject.getName());
            }
            return dbStat;
        }

        protected OracleUserProfile.ProfileResource fetchChild(@NotNull JDBCSession session, @NotNull OracleDataSource dataSource, @NotNull OracleUserProfile parent, @NotNull JDBCResultSet dbResult) throws SQLException, DBException {
            return new OracleUserProfile.ProfileResource(parent, (ResultSet)dbResult);
        }
    }

    static class RoleCache
    extends JDBCObjectCache<OracleDataSource, OracleRole> {
        RoleCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull OracleDataSource owner) throws SQLException {
            return session.prepareStatement("SELECT * FROM DBA_ROLES ORDER BY ROLE");
        }

        protected OracleRole fetchObject(@NotNull JDBCSession session, @NotNull OracleDataSource owner, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new OracleRole(owner, (ResultSet)resultSet);
        }
    }

    private class OracleOutputReader
    implements DBCServerOutputReader {
        private OracleOutputReader() {
        }

        public boolean isServerOutputEnabled() {
            return OracleDataSource.this.getContainer().getPreferenceStore().getBoolean("oracle.dbms.output");
        }

        public boolean isAsyncOutputReadSupported() {
            return false;
        }

        public void enableServerOutput(DBRProgressMonitor monitor, DBCExecutionContext context, boolean enable) throws DBCException {
            String sql = enable ? "BEGIN DBMS_OUTPUT.ENABLE(1000000); END;" : "BEGIN DBMS_OUTPUT.DISABLE; END;";
            try (DBCSession session = context.openSession(monitor, DBCExecutionPurpose.UTIL, (enable ? "Enable" : "Disable ") + "DBMS output");){
                JDBCUtils.executeSQL((Connection)((JDBCSession)session), (String)sql, (Object[])new Object[0]);
            }
            catch (SQLException e) {
                throw new DBCException((Throwable)e, context);
            }
        }

        public void readServerOutput(@NotNull DBRProgressMonitor monitor, @NotNull DBCExecutionContext context, @Nullable DBCExecutionResult executionResult, @Nullable DBCStatement statement, @NotNull DBCOutputWriter output) throws DBCException {
            try (JDBCSession session = (JDBCSession)context.openSession(monitor, DBCExecutionPurpose.UTIL, "Read DBMS output");){
                try (CallableStatement getLineProc = session.getOriginal().prepareCall("{CALL DBMS_OUTPUT.GET_LINE(?, ?)}");){
                    getLineProc.registerOutParameter(1, 12);
                    getLineProc.registerOutParameter(2, 4);
                    int status = 0;
                    while (status == 0) {
                        getLineProc.execute();
                        status = getLineProc.getInt(2);
                        if (status != 0) continue;
                        output.println(null, getLineProc.getString(1));
                    }
                }
                catch (SQLException e) {
                    throw new DBCException((Throwable)e, context);
                }
            }
        }
    }
}

