/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.hana.model.data;

import org.jkiss.dbeaver.ext.hana.model.data.wkb.XyzmMode;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class HANAXyzmModeFinder {
    private boolean allHaveZ = true;
    private boolean someHaveM = false;

    public static XyzmMode findXyzmMode(Geometry g) {
        HANAXyzmModeFinder instance = new HANAXyzmModeFinder();
        return instance.inspect(g);
    }

    private HANAXyzmModeFinder() {
    }

    private XyzmMode inspect(Geometry g) {
        this.inspectGeometry(g);
        if (this.allHaveZ && this.someHaveM) {
            return XyzmMode.XYZM;
        }
        if (this.allHaveZ) {
            return XyzmMode.XYZ;
        }
        if (this.someHaveM) {
            return XyzmMode.XYM;
        }
        return XyzmMode.XY;
    }

    private void inspectGeometry(Geometry g) {
        if (g instanceof Point) {
            this.inspectPoint((Point)g);
        } else if (g instanceof LineString) {
            this.inspectLineString((LineString)g);
        } else if (g instanceof Polygon) {
            this.inspectPolygon((Polygon)g);
        } else if (g instanceof GeometryCollection) {
            this.inspectCollection((GeometryCollection)g);
        } else {
            throw new AssertionError((Object)("Unknown geometry type " + String.valueOf(g.getClass())));
        }
    }

    private void inspectPoint(Point p) {
        this.inspectSequence(p.getCoordinateSequence());
    }

    private void inspectLineString(LineString ls) {
        this.inspectSequence(ls.getCoordinateSequence());
    }

    private void inspectPolygon(Polygon pg) {
        this.inspectLineString((LineString)pg.getExteriorRing());
        int numHoles = pg.getNumInteriorRing();
        for (int i = 0; i < numHoles; ++i) {
            this.inspectLineString((LineString)pg.getInteriorRingN(i));
        }
    }

    private void inspectCollection(GeometryCollection gc) {
        int numGeometries = gc.getNumGeometries();
        for (int i = 0; i < numGeometries; ++i) {
            this.inspectGeometry(gc.getGeometryN(i));
        }
    }

    private void inspectSequence(CoordinateSequence cs) {
        int size = cs.size();
        if (size == 0) {
            if (!cs.hasZ()) {
                this.allHaveZ = false;
            }
            if (cs.hasM()) {
                this.someHaveM = true;
            }
        }
        for (int i = 0; i < size; ++i) {
            if (!Double.isFinite(cs.getZ(i))) {
                this.allHaveZ = false;
            }
            if (!Double.isFinite(cs.getM(i))) continue;
            this.someHaveM = true;
        }
    }
}

