/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.duckdb.ui;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.jkiss.dbeaver.ext.duckdb.ui.internal.DuckDBMessages;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.connection.DBPConnectionConfiguration;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.connection.ConnectionPageAbstract;
import org.jkiss.utils.CommonUtils;

public class DuckDBConnectionPageAdvanced
extends ConnectionPageAbstract {
    private Combo sqlDollarQuotePlainCombo;
    private Combo sqlDollarQuoteTagCombo;

    public DuckDBConnectionPageAdvanced() {
        this.setTitle("Advanced");
    }

    public void createControl(Composite parent) {
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(1808));
        Group sqlGroup = new Group(group, 0);
        sqlGroup.setText(DuckDBMessages.dialog_setting_sql);
        sqlGroup.setLayoutData((Object)new GridData(32));
        sqlGroup.setLayout((Layout)new GridLayout(2, false));
        this.sqlDollarQuotePlainCombo = UIUtils.createLabelCombo((Composite)sqlGroup, (String)DuckDBMessages.dialog_setting_sql_dd_plain_label, (int)12);
        this.sqlDollarQuotePlainCombo.add(DuckDBMessages.dialog_setting_sql_dd_string);
        this.sqlDollarQuotePlainCombo.add(DuckDBMessages.dialog_setting_sql_dd_code_block);
        this.sqlDollarQuoteTagCombo = UIUtils.createLabelCombo((Composite)sqlGroup, (String)DuckDBMessages.dialog_setting_sql_dd_tag_label, (int)12);
        this.sqlDollarQuoteTagCombo.add(DuckDBMessages.dialog_setting_sql_dd_string);
        this.sqlDollarQuoteTagCombo.add(DuckDBMessages.dialog_setting_sql_dd_code_block);
        this.setControl((Control)group);
        this.loadSettings();
    }

    public void loadSettings() {
        DBPConnectionConfiguration config = this.getSite().getActiveDataSource().getConnectionConfiguration();
        this.sqlDollarQuotePlainCombo.select(CommonUtils.getBoolean((String)config.getProviderProperty("duckdb.dd.plain.string"), (boolean)false) ? 0 : 1);
        this.sqlDollarQuoteTagCombo.select(CommonUtils.getBoolean((String)config.getProviderProperty("duckdb.dd.tag.string"), (boolean)false) ? 0 : 1);
    }

    public void saveSettings(DBPDataSourceContainer dataSource) {
        dataSource.getConnectionConfiguration().setProviderProperty("duckdb.dd.plain.string", CommonUtils.toString((Object)(this.sqlDollarQuotePlainCombo.getSelectionIndex() == 0 ? 1 : 0)));
        dataSource.getConnectionConfiguration().setProviderProperty("duckdb.dd.tag.string", CommonUtils.toString((Object)(this.sqlDollarQuoteTagCombo.getSelectionIndex() == 0 ? 1 : 0)));
    }

    public boolean isComplete() {
        return true;
    }
}

