/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.db2.tasks;

import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.edit.DBEPersistAction;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteHandler;
import org.jkiss.dbeaver.model.sql.task.SQLToolExecuteSettings;
import org.jkiss.dbeaver.model.sql.task.SQLToolRunStatisticsGenerator;
import org.jkiss.dbeaver.model.sql.task.SQLToolStatistics;
import org.jkiss.dbeaver.model.struct.DBSObject;

public abstract class DB2ToolWithStatus<OBJECT_TYPE extends DBSObject, SETTINGS extends SQLToolExecuteSettings<OBJECT_TYPE>>
extends SQLToolExecuteHandler<OBJECT_TYPE, SETTINGS>
implements SQLToolRunStatisticsGenerator<OBJECT_TYPE, SETTINGS, DBEPersistAction> {
    @NotNull
    public List<ToolStatus> getExecuteStatistics(@NotNull OBJECT_TYPE object, @NotNull SETTINGS settings, @NotNull DBEPersistAction action, @NotNull DBCSession session, @NotNull DBCStatement dbStat) throws DBCException {
        ArrayList<ToolStatus> statusList = new ArrayList<ToolStatus>();
        try {
            int warnNum = 0;
            for (SQLWarning warning = ((JDBCStatement)dbStat).getWarnings(); warning != null; warning = warning.getNextWarning()) {
                statusList.add(new ToolStatus(this, object, warning.getMessage()));
                ++warnNum;
            }
            if (warnNum == 0) {
                statusList.add(new ToolStatus(this, object, "Done"));
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return statusList;
    }

    public class ToolStatus
    extends SQLToolStatistics<OBJECT_TYPE> {
        private final String message;

        /*
         * WARNING - Possible parameter corruption
         */
        ToolStatus(OBJECT_TYPE object, String message) {
            super(object);
            this.message = message;
        }

        @Property(viewable=true, order=1)
        public OBJECT_TYPE getObject() {
            return (DBSObject)super.getObject();
        }

        @Property(viewable=true, order=2)
        public String getMessage() {
            return this.message;
        }
    }
}

