/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.dameng.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.ext.dameng.DamengConstants;
import org.jkiss.dbeaver.ext.dameng.model.DamengDataSource;
import org.jkiss.dbeaver.ext.dameng.model.DamengPrivObject;
import org.jkiss.dbeaver.ext.dameng.model.DamengPrivSystem;
import org.jkiss.dbeaver.ext.dameng.model.DamengPrivUser;
import org.jkiss.dbeaver.ext.dameng.model.DamengUtils;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPObjectWithLongId;
import org.jkiss.dbeaver.model.DBPRefreshableObject;
import org.jkiss.dbeaver.model.DBPScriptObject;
import org.jkiss.dbeaver.model.access.DBARole;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.impl.jdbc.cache.JDBCObjectCache;
import org.jkiss.dbeaver.model.meta.Association;
import org.jkiss.dbeaver.model.meta.Property;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DamengRole
implements DBARole,
DBPScriptObject,
DBPObjectWithLongId,
DBPRefreshableObject {
    private DamengDataSource dataSource;
    private Long id;
    private String name;
    private Timestamp createTime;
    private UserPrivCache userPrivCache = new UserPrivCache();
    private SystemPrivCache systemPrivCache = new SystemPrivCache();
    private ObjectPrivCache objectPrivCache = new ObjectPrivCache();

    public DamengRole(DamengDataSource damengDataSource, JDBCResultSet resultSet) {
        this.dataSource = damengDataSource;
        this.id = JDBCUtils.safeGetLong((ResultSet)resultSet, (String)"ID");
        this.name = JDBCUtils.safeGetString((ResultSet)resultSet, (String)"NAME");
        this.createTime = JDBCUtils.safeGetTimestamp((ResultSet)resultSet, (String)"CRTDATE");
    }

    @Property(viewable=true, order=1)
    public long getObjectId() {
        return this.id;
    }

    @Property(viewable=true, order=2)
    @NotNull
    public String getName() {
        return this.name;
    }

    @Property(viewable=true, order=3)
    public Timestamp getCreateTime() {
        return this.createTime;
    }

    public String getDescription() {
        return null;
    }

    public boolean isPersisted() {
        return true;
    }

    public DBSObject getParentObject() {
        return this.getDataSource().getContainer();
    }

    public DBPDataSource getDataSource() {
        return this.dataSource;
    }

    @NotNull
    public String getObjectDefinitionText(@NotNull DBRProgressMonitor monitor, @NotNull Map<String, Object> options) throws DBException {
        return DamengUtils.getDDL(monitor, (DBSObject)this, DamengConstants.ObjectType.ROLE, null);
    }

    @Association
    public Collection<DamengPrivUser> getUserPrivs(DBRProgressMonitor monitor) throws DBException {
        return this.userPrivCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DamengPrivSystem> getSystemPrivs(DBRProgressMonitor monitor) throws DBException {
        return this.systemPrivCache.getAllObjects(monitor, (DBSObject)this);
    }

    @Association
    public Collection<DamengPrivObject> getObjectPrivs(DBRProgressMonitor monitor) throws DBException {
        return this.objectPrivCache.getAllObjects(monitor, (DBSObject)this);
    }

    public DBSObject refreshObject(@NotNull DBRProgressMonitor monitor) throws DBException {
        this.userPrivCache.clearCache();
        this.objectPrivCache.clearCache();
        this.systemPrivCache.clearCache();
        return this;
    }

    static class UserPrivCache
    extends JDBCObjectCache<DamengRole, DamengPrivUser> {
        UserPrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DamengRole damengRole) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT DISTINCT OBJ.ID,\nOBJ.NAME,\nGRANTS.GRANTABLE,\nOBJ.SUBTYPE$ FROM \nSYSOBJECTS OBJ,\nsysgrants GRANTS\nWHERE GRANTS.PRIVID = -1\nAND OBJ.TYPE$ = 'UR'\nAND OBJ.ID = GRANTS.URID\nAND GRANTS.OBJID = ? ");
            dbStat.setLong(1, damengRole.getObjectId());
            return dbStat;
        }

        protected DamengPrivUser fetchObject(@NotNull JDBCSession session, @NotNull DamengRole damengRole, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new DamengPrivUser(damengRole, resultSet);
        }
    }

    static class SystemPrivCache
    extends JDBCObjectCache<DamengRole, DamengPrivSystem> {
        SystemPrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DamengRole damengRole) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT\nPRIVID AS ID,\nSF_GET_SYS_PRIV(PRIVID) AS PRIV,\nGRANT_OBJ.NAME AS GRANTOR_NAME,\nGRANTABLE\nFROM\nSYSGRANTS GRANTS\nLEFT JOIN SYSOBJECTS GRANT_OBJ ON\nGRANTS.GRANTOR = GRANT_OBJ.ID\nWHERE\nNOT (OBJID != -1\nOR COLID != -1)\nAND PRIVID != -1\nAND URID = ?");
            dbStat.setLong(1, damengRole.getObjectId());
            return dbStat;
        }

        protected DamengPrivSystem fetchObject(@NotNull JDBCSession session, @NotNull DamengRole damengRole, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new DamengPrivSystem(damengRole, resultSet);
        }
    }

    static class ObjectPrivCache
    extends JDBCObjectCache<DamengRole, DamengPrivObject> {
        ObjectPrivCache() {
        }

        @NotNull
        protected JDBCStatement prepareObjectsStatement(@NotNull JDBCSession session, @NotNull DamengRole damengRole) throws SQLException {
            JDBCPreparedStatement dbStat = session.prepareStatement("SELECT\nSF_GET_OBJ_FULL_NAME(OBJID,COLID) AS OBJECT_NAME,\nSF_GET_SYS_PRIV(PRIVID) AS PRIV,\nGRANTOR_OBJ.name AS GRANTOR_NAME,\nGRANTABLE,\nGRANT_OBJ.TYPE$ AS TYPE,\nDECODE(GRANT_OBJ.SUBTYPE$,'PROC',DECODE(GRANT_OBJ.INFO1 & 0X01,0,'FUNCTION',1,'PROCEDURE'),GRANT_OBJ.SUBTYPE$) AS SUB_TYPE\nFROM\nSYSGRANTS GRANTS,\nSYSOBJECTS GRANT_OBJ,\nSYSOBJECTS GRANTOR_OBJ\nWHERE\nGRANT_OBJ.ID = GRANTS.OBJID\nAND GRANTOR_OBJ.ID = GRANTS.GRANTOR\nAND (OBJID != -1 OR COLID != -1)\nAND PRIVID != -1\nAND URID = ?");
            dbStat.setLong(1, damengRole.getObjectId());
            return dbStat;
        }

        protected DamengPrivObject fetchObject(@NotNull JDBCSession session, @NotNull DamengRole damengRole, @NotNull JDBCResultSet resultSet) throws SQLException, DBException {
            return new DamengPrivObject(damengRole, (ResultSet)resultSet);
        }
    }
}

