/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.debug.ui.actions.OpenLaunchDialogAction;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.CoolBar;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.debug.ui.DebugUI;
import org.jkiss.dbeaver.debug.ui.internal.DebugUIInternals;
import org.jkiss.dbeaver.model.struct.DBSObject;

public class DatabaseLaunchContributionItem
extends ContributionItem {
    private static final Object[] NO_OBJECTS = new Object[0];
    private final String mode;
    private ILaunchGroup defaultGroup = null;
    private Map<String, ILaunchGroup> groupsByCategory = null;

    protected DatabaseLaunchContributionItem(String mode) {
        this.mode = mode;
        ILaunchGroup[] groups = DebugUITools.getLaunchGroups();
        this.groupsByCategory = new HashMap<String, ILaunchGroup>(3);
        for (int i = 0; i < groups.length; ++i) {
            ILaunchGroup group = groups[i];
            if (!group.getMode().equals(mode)) continue;
            if (group.getCategory() == null) {
                this.defaultGroup = group;
                continue;
            }
            this.groupsByCategory.put(group.getCategory(), group);
        }
    }

    public void fill(Menu menu, int index) {
        Object[] selected = this.extractSelectedObjects();
        int accelerator = 1;
        List<ILaunchConfiguration> configurations = this.extractSharedConfigurations(selected);
        for (ILaunchConfiguration configuration : configurations) {
            IAction action = DebugUIInternals.createConfigurationAction(configuration, this.mode, accelerator);
            if (action == null) continue;
            ++accelerator;
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(menu, -1);
        }
        Map<IAction, String> shortcutActions = DebugUIInternals.createShortcutActions(selected, this.mode, accelerator);
        if (menu.getItemCount() > 0 && shortcutActions.size() > 0) {
            new MenuItem(menu, 2);
        }
        ArrayList<String> categories = new ArrayList<String>();
        Set<IAction> actions = shortcutActions.keySet();
        for (IAction action : actions) {
            String category = shortcutActions.get(action);
            if (category != null && !categories.contains(category)) {
                categories.add(category);
            }
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(menu, -1);
        }
        if (categories.isEmpty()) {
            if (this.defaultGroup != null) {
                if (accelerator > 1) {
                    new MenuItem(menu, 2);
                }
                OpenLaunchDialogAction action = new OpenLaunchDialogAction(this.defaultGroup.getIdentifier());
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(menu, -1);
            }
        } else {
            boolean addedSep = false;
            for (String category : categories) {
                ILaunchGroup group = this.defaultGroup;
                if (category != null) {
                    group = this.groupsByCategory.get(category);
                }
                if (group == null) continue;
                if (accelerator > 1 && !addedSep) {
                    new MenuItem(menu, 2);
                    addedSep = true;
                }
                OpenLaunchDialogAction action = new OpenLaunchDialogAction(group.getIdentifier());
                ActionContributionItem item = new ActionContributionItem((IAction)action);
                item.fill(menu, -1);
            }
        }
    }

    public void fill(CoolBar parent, int index) {
        super.fill(parent, index);
    }

    public void fill(ToolBar parent, int index) {
        super.fill(parent, index);
    }

    protected Object[] extractSelectedObjects() {
        IEditorPart activeEditor;
        DBSObject databaseObject;
        IWorkbenchPage activePage;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return NO_OBJECTS;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structured = (IStructuredSelection)selection;
            Object[] array = structured.toArray();
            Object o = structured.getFirstElement();
            if (o instanceof IEditorPart) {
                IEditorPart part = (IEditorPart)o;
                array[0] = part.getEditorInput();
            }
            return array;
        }
        if (selection instanceof ITextSelection && (activePage = window.getActivePage()) != null && (databaseObject = DebugUI.extractDatabaseObject(activeEditor = activePage.getActiveEditor())) != null) {
            return new Object[]{databaseObject};
        }
        return NO_OBJECTS;
    }

    protected List<ILaunchConfiguration> extractSharedConfigurations(Object[] selection) {
        ArrayList<ILaunchConfiguration> configurations = new ArrayList<ILaunchConfiguration>();
        for (Object object : selection) {
            ILaunchConfiguration config = DebugUIInternals.isSharedConfig(object);
            if (config == null) continue;
            configurations.add(config);
        }
        return configurations;
    }
}

