/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui.actions;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTargetExtension2;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.dbeaver.debug.core.breakpoints.DatabaseLineBreakpoint;
import org.jkiss.dbeaver.debug.core.breakpoints.IDatabaseBreakpoint;
import org.jkiss.dbeaver.debug.ui.DebugUI;
import org.jkiss.dbeaver.model.DBPEvaluationContext;
import org.jkiss.dbeaver.model.DBPNamedObject;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.utils.GeneralUtils;

public class ToggleProcedureBreakpointTarget
implements IToggleBreakpointsTargetExtension2 {
    public void toggleBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        this.toggleLineBreakpoints(part, selection);
    }

    public boolean canToggleBreakpoints(IWorkbenchPart part, ISelection selection) {
        return this.canToggleLineBreakpoints(part, selection);
    }

    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        IBreakpoint[] breakpoints;
        IEditorPart editorPart = (IEditorPart)part;
        IResource resource = this.extractResource(editorPart, selection);
        if (resource == null) {
            return;
        }
        DBSObject databaseObject = DebugUI.extractDatabaseObject(editorPart);
        if (databaseObject == null) {
            return;
        }
        DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), databaseObject, false);
        if (node == null) {
            return;
        }
        String nodeItemPath = node.getNodeUri();
        ITextSelection textSelection = (ITextSelection)selection;
        int lineNumber = textSelection.getStartLine();
        IBreakpoint[] iBreakpointArray = breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.jkiss.dbeaver.debug.core.database");
        int n = breakpoints.length;
        int n2 = 0;
        while (n2 < n) {
            IDatabaseBreakpoint databaseBreakpoint;
            IBreakpoint breakpoint = iBreakpointArray[n2];
            if (breakpoint instanceof IDatabaseBreakpoint && nodeItemPath.equals((databaseBreakpoint = (IDatabaseBreakpoint)breakpoint).getNodePath()) && ((ILineBreakpoint)breakpoint).getLineNumber() == lineNumber + 1) {
                DebugUITools.deleteBreakpoints((IBreakpoint[])new IBreakpoint[]{breakpoint}, (Shell)part.getSite().getShell(), null);
                return;
            }
            ++n2;
        }
        int charstart = -1;
        int charend = -1;
        DBGBreakpointDescriptor breakpointDescriptor = (DBGBreakpointDescriptor)GeneralUtils.adapt((Object)databaseObject, DBGBreakpointDescriptor.class);
        if (breakpointDescriptor == null) {
            throw new CoreException(GeneralUtils.makeErrorStatus((String)("Object '" + DBUtils.getObjectFullName((DBPNamedObject)databaseObject, (DBPEvaluationContext)DBPEvaluationContext.UI) + "' doesn't support breakpoints")));
        }
        new DatabaseLineBreakpoint(databaseObject, (DBNNode)node, resource, breakpointDescriptor, lineNumber + 1, charstart, charend, true);
    }

    protected IResource extractResource(IEditorPart part, ISelection selection) {
        DBSObject databaseObject = DebugUI.extractDatabaseObject(part);
        return ToggleProcedureBreakpointTarget.resolveWorkspaceResource(databaseObject);
    }

    /*
     * WARNING - void declaration
     */
    public static IResource resolveWorkspaceResource(DBSObject dbsObject) {
        IProject iProject;
        DBPProject dBPProject;
        DBNDatabaseNode node = DBWorkbench.getPlatform().getNavigatorModel().getNodeByObject(dbsObject);
        if (node == null || !((dBPProject = node.getOwnerProject()) instanceof RCPProject)) {
            iProject = null;
        } else {
            void rcpProject;
            RCPProject rCPProject = (RCPProject)dBPProject;
            iProject = rcpProject.getEclipseProject();
        }
        return iProject;
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) throws CoreException {
    }

    public boolean canToggleBreakpointsWithEvent(IWorkbenchPart part, ISelection selection, Event event) {
        return false;
    }
}

