/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui;

import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.ui.DBGConfigurationPanel;
import org.jkiss.dbeaver.debug.ui.DBGConfigurationPanelContainer;
import org.jkiss.dbeaver.debug.ui.internal.DebugConfigurationPanelDescriptor;
import org.jkiss.dbeaver.debug.ui.internal.DebugConfigurationPanelRegistry;
import org.jkiss.dbeaver.debug.ui.internal.DebugUIMessages;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.registry.DataSourceRegistry;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.RunnableContextDelegate;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.SelectDataSourceCombo;
import org.jkiss.utils.CommonUtils;

public class DatabaseDebugConfigurationTab
extends AbstractLaunchConfigurationTab
implements DBGConfigurationPanelContainer {
    protected static final Log log = Log.getLog(DatabaseDebugConfigurationTab.class);
    private DebugConfigurationPanelDescriptor selectedDebugType;
    private DBGConfigurationPanel selectedDebugPanel;
    private ILaunchConfiguration currentConfiguration;
    private Text driverText;
    private SelectDataSourceCombo connectionCombo;
    private Composite typesGroup;
    private Composite panelPlaceholder;

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), this.getHelpContextId());
        comp.setLayout((Layout)new GridLayout(1, true));
        comp.setFont(parent.getFont());
        this.createComponents(comp);
    }

    protected void createComponents(Composite comp) {
        this.createConnectionSettingsGroup(comp);
        this.createPanelListGroup(comp);
    }

    protected void createConnectionSettingsGroup(Composite composite) {
        Composite group = UIUtils.createTitledComposite((Composite)composite, (String)DebugUIMessages.DatabaseTab_connection_group_text, (int)4, (int)768);
        UIUtils.createControlLabel((Composite)group, (String)DebugUIMessages.DatabaseTab_datasource_label_text);
        this.connectionCombo = new SelectDataSourceCombo(group){

            protected void onDataSourceChange(DBPDataSourceContainer dataSource) {
                String driverName = dataSource == null ? "" : dataSource.getDriver().getFullName();
                DatabaseDebugConfigurationTab.this.driverText.setText(driverName);
                DatabaseDebugConfigurationTab.this.setDirty(true);
                DatabaseDebugConfigurationTab.this.loadConnectionDebugTypes();
                DatabaseDebugConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        };
        this.connectionCombo.addItem(null);
        for (DBPDataSourceContainer ds : DataSourceRegistry.getAllDataSources()) {
            this.connectionCombo.addItem((Object)ds);
        }
        this.driverText = UIUtils.createLabelText((Composite)group, (String)DebugUIMessages.DatabaseTab_driver_label_text, (String)"", (int)8);
    }

    protected void createPanelListGroup(Composite composite) {
        this.typesGroup = UIUtils.createTitledComposite((Composite)composite, (String)DebugUIMessages.DatabaseTab_debug_type_group_text, (int)3, (int)768);
        this.panelPlaceholder = UIUtils.createPlaceholder((Composite)composite, (int)1, (int)5);
        this.loadConnectionDebugTypes();
    }

    private void loadConnectionDebugTypes() {
        Control[] controlArray = this.typesGroup.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        DBPDataSourceContainer dataSource = (DBPDataSourceContainer)this.connectionCombo.getSelectedItem();
        if (dataSource == null) {
            UIUtils.createInfoLabel((Composite)this.typesGroup, (String)"Select a connection to see available debug types");
        } else {
            List<DebugConfigurationPanelDescriptor> panels = DebugConfigurationPanelRegistry.getInstance().getPanels(dataSource);
            if (CommonUtils.isEmpty(panels)) {
                UIUtils.createInfoLabel((Composite)this.typesGroup, (String)("Driver '" + dataSource.getDriver().getFullName() + "' doesn't support debugging"));
            } else {
                for (DebugConfigurationPanelDescriptor panel : panels) {
                    final Button typeSelector = new Button(this.typesGroup, 16);
                    typeSelector.setText(panel.getName());
                    if (!CommonUtils.isEmpty((String)panel.getDescription())) {
                        typeSelector.setToolTipText(panel.getDescription());
                    }
                    typeSelector.setData((Object)panel);
                    if (panel.isValid()) {
                        typeSelector.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                if (typeSelector.getSelection()) {
                                    DatabaseDebugConfigurationTab.this.setDirty(true);
                                    DatabaseDebugConfigurationTab.this.setDebugType((DBPDataSourceContainer)DatabaseDebugConfigurationTab.this.connectionCombo.getSelectedItem(), (DebugConfigurationPanelDescriptor)((Object)typeSelector.getData()));
                                    DatabaseDebugConfigurationTab.this.typesGroup.getParent().layout(true, true);
                                }
                            }
                        });
                        continue;
                    }
                    typeSelector.setEnabled(false);
                }
            }
        }
        this.setDebugType(dataSource, null);
        this.typesGroup.getParent().layout(true, true);
    }

    private void setDebugType(DBPDataSourceContainer dataSource, DebugConfigurationPanelDescriptor debugPanel) {
        Control c;
        int n;
        int n2;
        Control[] controlArray;
        block12: {
            if (this.selectedDebugType == debugPanel) {
                return;
            }
            controlArray = this.panelPlaceholder.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                c = controlArray[n];
                c.dispose();
                ++n;
            }
            if (debugPanel != null) {
                try {
                    this.selectedDebugType = debugPanel;
                    this.selectedDebugPanel = debugPanel.createPanel();
                    this.selectedDebugPanel.createPanel(this.panelPlaceholder, this);
                    if (dataSource == null || this.currentConfiguration == null) break block12;
                    try {
                        this.selectedDebugPanel.loadConfiguration(dataSource, this.currentConfiguration.getAttributes());
                    }
                    catch (CoreException e) {
                        this.setWarningMessage("Error loading panel configuration: " + e.getMessage());
                    }
                }
                catch (DBException e) {
                    this.selectedDebugType = null;
                    this.selectedDebugPanel = null;
                    DBWorkbench.getPlatformUI().showError("Panel create error", "Can't create debugger config panel " + debugPanel.getId(), (Throwable)e);
                }
            } else {
                this.selectedDebugType = null;
                this.selectedDebugPanel = null;
            }
        }
        if (this.selectedDebugType == null) {
            UIUtils.createInfoLabel((Composite)this.panelPlaceholder, (String)"Select a debug type to see debug configuration");
        } else {
            controlArray = this.typesGroup.getChildren();
            n2 = controlArray.length;
            n = 0;
            while (n < n2) {
                c = controlArray[n];
                if (c instanceof Button && c.getData() == debugPanel) {
                    ((Button)c).setSelection(true);
                    break;
                }
                ++n;
            }
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.currentConfiguration = configuration;
        try {
            DBPDataSourceContainer dataSource = null;
            try {
                dataSource = DebugUtils.getDataSourceContainer((ILaunchConfiguration)configuration);
            }
            catch (CoreException e) {
                log.debug((Object)e);
            }
            this.connectionCombo.select((Object)dataSource);
            if (dataSource != null) {
                this.driverText.setText(dataSource.getDriver().getFullName());
            } else {
                this.driverText.setText("");
            }
            this.loadConnectionDebugTypes();
            String typeId = configuration.getAttribute("org.jkiss.dbeaver.debug.core.ATTR_DEBUG_TYPE", null);
            DebugConfigurationPanelDescriptor savedPanel = null;
            if (typeId != null && (savedPanel = DebugConfigurationPanelRegistry.getInstance().getPanel(typeId)) == null) {
                this.setWarningMessage("Debug type '" + typeId + "' cannot be resolved");
            }
            this.setDebugType(dataSource, savedPanel);
        }
        catch (CoreException e) {
            this.setWarningMessage("Error loading debug configuration: " + e.getMessage());
        }
        this.scheduleUpdateJob();
    }

    public Image getImage() {
        DBPDataSourceContainer dataSource;
        if (this.connectionCombo != null && (dataSource = (DBPDataSourceContainer)this.connectionCombo.getSelectedItem()) != null) {
            return DBeaverIcons.getImage((DBPImage)dataSource.getDriver().getIcon());
        }
        return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_DATABASE);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        DBPDataSourceContainer dataSource = (DBPDataSourceContainer)this.connectionCombo.getSelectedItem();
        configuration.setAttribute("org.jkiss.dbeaver.debug.core.ATTR_DATASOURCE_ID", dataSource == null ? null : dataSource.getId());
        configuration.setAttribute("org.jkiss.dbeaver.debug.core.ATTR_DEBUG_TYPE", this.selectedDebugType == null ? null : this.selectedDebugType.getId());
        if (this.selectedDebugPanel != null) {
            HashMap<String, Object> attrs = new HashMap<String, Object>();
            this.selectedDebugPanel.saveConfiguration(dataSource, attrs);
            DebugUtils.putContextInConfiguration((ILaunchConfigurationWorkingCopy)configuration, attrs);
        }
    }

    public String getName() {
        return DebugUIMessages.DatabaseTab_name;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return this.connectionCombo.getSelectedItem() != null && this.selectedDebugType != null && this.selectedDebugPanel.isValid();
    }

    public boolean canSave() {
        return this.connectionCombo.getSelectedItem() != null && this.selectedDebugType != null;
    }

    @Override
    public DBPDataSourceContainer getDataSource() {
        return (DBPDataSourceContainer)this.connectionCombo.getSelectedItem();
    }

    @Override
    public void updateDialogState() {
        this.setDirty(true);
        this.updateLaunchConfigurationDialog();
    }

    @Override
    public void setWarningMessage(String message) {
        super.setWarningMessage(message);
    }

    @Override
    public DBRRunnableContext getRunnableContext() {
        return new RunnableContextDelegate((IRunnableContext)this.getLaunchConfigurationDialog());
    }
}

