/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui.internal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.LaunchConfigurationAction;
import org.eclipse.debug.internal.ui.actions.LaunchShortcutAction;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.jkiss.dbeaver.debug.core.DebugUtils;

public class DebugUIInternals {
    public static ILaunchConfiguration isSharedConfig(Object receiver) {
        LaunchConfigurationManager launchConfigurationManager = DebugUIPlugin.getDefault().getLaunchConfigurationManager();
        return launchConfigurationManager.isSharedConfig(receiver);
    }

    public static IAction createConfigurationAction(ILaunchConfiguration config, String mode, int accelerator) {
        if (DebugUtils.canLaunch((ILaunchConfiguration)config, (String)mode)) {
            String configName = config.getName();
            ImageDescriptor imageDescriptor = DebugUITools.getDefaultImageDescriptor((Object)config);
            LaunchConfigurationAction action = new LaunchConfigurationAction(config, mode, configName, imageDescriptor, accelerator);
            return action;
        }
        return null;
    }

    public static Map<IAction, String> createShortcutActions(Object[] selected, String mode, int accelerator) {
        LinkedHashMap<IAction, String> result = new LinkedHashMap<IAction, String>();
        if (selected == null) {
            return result;
        }
        List<Object> selection = Arrays.asList(selected);
        IEvaluationContext context = DebugUIPlugin.createEvaluationContext(selection);
        context.setAllowPluginActivation(true);
        context.addVariable("selection", selection);
        List allShortCuts = DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchShortcuts();
        ArrayList<LaunchShortcutExtension> filteredShortCuts = new ArrayList<LaunchShortcutExtension>();
        Iterator iter = allShortCuts.iterator();
        while (iter.hasNext()) {
            LaunchShortcutExtension ext = (LaunchShortcutExtension)iter.next();
            if (WorkbenchActivityHelper.filterItem((Object)ext)) continue;
            try {
                Expression expr = ext.getContextualLaunchEnablementExpression();
                if (!ext.evalEnablementExpression(context, expr)) continue;
                filteredShortCuts.add(ext);
            }
            catch (CoreException e) {
                Status status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), "Launch shortcut '" + ext.getId() + "' enablement expression caused exception. Shortcut was removed.", (Throwable)e);
                DebugUIPlugin.log((IStatus)status);
                iter.remove();
            }
        }
        for (LaunchShortcutExtension ext : filteredShortCuts) {
            for (String supported : ext.getModes()) {
                String contextLabel;
                if (!supported.equals(mode)) continue;
                LaunchShortcutAction action = new LaunchShortcutAction(supported, ext);
                action.setActionDefinitionId(ext.getId() + "." + supported);
                String helpContextId = ext.getHelpContextId();
                if (helpContextId != null) {
                    PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, helpContextId);
                }
                StringBuffer label = new StringBuffer();
                if (accelerator >= 0 && accelerator < 10) {
                    label.append('&');
                    label.append(accelerator);
                    label.append(' ');
                }
                label.append((contextLabel = ext.getContextLabel(supported)) != null ? contextLabel : action.getText());
                action.setText(label.toString());
                String category = ext.getCategory();
                result.put((IAction)action, category);
                ++accelerator;
            }
        }
        return result;
    }
}

