/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.core.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.debug.DBGStackFrame;
import org.jkiss.dbeaver.debug.DBGVariable;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.core.model.DatabaseDebugElement;
import org.jkiss.dbeaver.debug.core.model.DatabaseThread;
import org.jkiss.dbeaver.debug.core.model.DatabaseVariable;
import org.jkiss.dbeaver.debug.core.model.IDatabaseDebugTarget;

public class DatabaseStackFrame
extends DatabaseDebugElement
implements IStackFrame {
    private static final IRegisterGroup[] NO_REGISTER_GROUPS = new IRegisterGroup[0];
    private static final IVariable[] NO_VARIABLES = new IVariable[0];
    private static Log log = Log.getLog(DatabaseStackFrame.class);
    private final List<DatabaseVariable> variables = new ArrayList<DatabaseVariable>();
    private final DatabaseThread thread;
    private final DBGStackFrame dbgStackFrame;
    private boolean refreshVariables = true;

    public DatabaseStackFrame(DatabaseThread thread, DBGStackFrame dbgStackFrame) {
        super(thread.getDatabaseDebugTarget());
        this.thread = thread;
        this.dbgStackFrame = dbgStackFrame;
    }

    public boolean canStepInto() {
        return this.getThread().canStepInto();
    }

    public boolean canStepOver() {
        return this.getThread().canStepOver();
    }

    public boolean canStepReturn() {
        return this.getThread().canStepReturn();
    }

    public boolean isStepping() {
        return this.getThread().isStepping();
    }

    public void stepInto() throws DebugException {
        this.getThread().stepInto();
    }

    public void stepOver() throws DebugException {
        this.getThread().stepOver();
    }

    public void stepReturn() throws DebugException {
        this.getThread().canStepReturn();
    }

    public boolean canResume() {
        return this.getThread().canResume();
    }

    public boolean canSuspend() {
        return this.getThread().canSuspend();
    }

    public boolean isSuspended() {
        return this.getThread().isSuspended();
    }

    public void resume() throws DebugException {
        this.getThread().resume();
    }

    public void suspend() throws DebugException {
        this.getThread().suspend();
    }

    public boolean canTerminate() {
        return this.getThread().canTerminate();
    }

    public boolean isTerminated() {
        return this.getThread().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getThread().terminate();
    }

    public IThread getThread() {
        return this.thread;
    }

    public IVariable[] getVariables() throws DebugException {
        try {
            IDatabaseDebugTarget debugTarget = this.getDatabaseDebugTarget();
            List<? extends DBGVariable<?>> variables = debugTarget.getSession().getVariables(this.dbgStackFrame);
            this.rebuildVariables(variables);
        }
        catch (DBGException e) {
            log.debug((Object)"Error getting variables", (Throwable)((Object)e));
        }
        if (this.variables.isEmpty()) {
            return NO_VARIABLES;
        }
        return this.variables.toArray(new IVariable[this.variables.size()]);
    }

    protected void invalidateVariables() {
        this.refreshVariables = true;
    }

    protected void rebuildVariables(List<? extends DBGVariable<?>> dbgVariables) {
        try {
            int frameLN = this.dbgStackFrame.getLineNumber();
            this.variables.clear();
            LinkedHashMap<String, DBGVariable<Object>> filtered = new LinkedHashMap<String, DBGVariable<Object>>();
            for (DBGVariable<Object> dbgVariable : dbgVariables) {
                String name = dbgVariable.getName();
                DBGVariable existing = (DBGVariable)filtered.get(name);
                if (existing == null) {
                    filtered.put(name, dbgVariable);
                    continue;
                }
                int existingLN = existing.getLineNumber();
                int currentLN = dbgVariable.getLineNumber();
                int delta = currentLN - existingLN;
                if (delta >= 0) {
                    filtered.put(name, dbgVariable);
                    continue;
                }
                String pattern = "Already have {0} and ignored {1} for frame at {2}";
                String message = NLS.bind((String)pattern, (Object[])new Object[]{existing, dbgVariable, frameLN});
                log.error((Object)message);
            }
            for (DBGVariable<Object> dbgVariable : filtered.values()) {
                DatabaseVariable variable = new DatabaseVariable(this.getDatabaseDebugTarget(), dbgVariable);
                this.variables.add(variable);
            }
        }
        finally {
            this.refreshVariables = false;
        }
    }

    public boolean hasVariables() throws DebugException {
        return this.isSuspended();
    }

    public int getLineNumber() throws DebugException {
        return this.dbgStackFrame.getLineNumber();
    }

    public int getCharStart() throws DebugException {
        return -1;
    }

    public int getCharEnd() throws DebugException {
        return -1;
    }

    public String getName() throws DebugException {
        String pattern = "{0} line: {1}";
        return NLS.bind((String)pattern, (Object)this.dbgStackFrame.getName(), (Object)this.dbgStackFrame.getLineNumber());
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return NO_REGISTER_GROUPS;
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public String getSource() throws DebugException {
        String source;
        try {
            IDatabaseDebugTarget debugTarget = this.getDatabaseDebugTarget();
            source = debugTarget.getSession().getSource(this.dbgStackFrame);
        }
        catch (DBGException e) {
            String message = NLS.bind((String)"Unable to retrieve sources for stack {0}", (Object)this.dbgStackFrame);
            Status status = DebugUtils.newErrorStatus(message, (Throwable)((Object)e));
            throw new DebugException((IStatus)status);
        }
        return source;
    }

    public Object getSourceIdentifier() {
        return this.dbgStackFrame.getSourceIdentifier();
    }
}

