/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.tools.transfer.database;

import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.tools.transfer.DTUtils;
import org.jkiss.dbeaver.tools.transfer.DataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.IDataTransferSettings;
import org.jkiss.dbeaver.tools.transfer.internal.DTMessages;
import org.jkiss.utils.CommonUtils;

public class DatabaseProducerSettings
implements IDataTransferSettings {
    private static final int DEFAULT_SEGMENT_SIZE = 100000;
    private static final int DEFAULT_FETCH_SIZE = 10000;
    private int segmentSize = 100000;
    private boolean openNewConnections = true;
    private boolean queryRowCount = true;
    private FetchedRowsPolicy fetchedRowsPolicy;
    private ExtractType extractType = ExtractType.SINGLE_QUERY;
    private int fetchSize = 10000;

    public int getSegmentSize() {
        return this.segmentSize;
    }

    public void setSegmentSize(int segmentSize) {
        if (segmentSize > 0) {
            this.segmentSize = segmentSize;
        }
    }

    public boolean isQueryRowCount() {
        return this.queryRowCount;
    }

    public void setQueryRowCount(boolean queryRowCount) {
        this.queryRowCount = queryRowCount;
    }

    public int getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Nullable
    public FetchedRowsPolicy getFetchedRowsPolicy() {
        return this.fetchedRowsPolicy;
    }

    public void setFetchedRowsPolicy(@Nullable FetchedRowsPolicy fetchedRowsPolicy) {
        this.fetchedRowsPolicy = fetchedRowsPolicy;
    }

    public boolean isOpenNewConnections() {
        return this.openNewConnections;
    }

    public void setOpenNewConnections(boolean openNewConnections) {
        this.openNewConnections = openNewConnections;
    }

    @NotNull
    public ExtractType getExtractType() {
        return this.extractType;
    }

    public void setExtractType(@NotNull ExtractType extractType) {
        this.extractType = extractType;
    }

    @Override
    public void loadSettings(DBRRunnableContext runnableContext, DataTransferSettings dataTransferSettings, Map<String, Object> settings) {
        this.extractType = (ExtractType)CommonUtils.valueOf(ExtractType.class, (String)((String)settings.get("extractType")), (Enum)this.extractType);
        this.segmentSize = CommonUtils.toInt((Object)settings.get("segmentSize"), (int)100000);
        this.fetchSize = CommonUtils.toInt((Object)settings.get("fetchSize"), (int)this.fetchSize);
        this.openNewConnections = CommonUtils.toBoolean((Object)settings.get("openNewConnections"));
        this.queryRowCount = CommonUtils.toBoolean((Object)settings.get("queryRowCount"));
        boolean fetchedRowsOnly = CommonUtils.toBoolean((Object)settings.get("fetchedRowsOnly"));
        boolean selectedRowsOnly = CommonUtils.toBoolean((Object)settings.get("selectedRowsOnly"));
        boolean selectedColumnsOnly = CommonUtils.toBoolean((Object)settings.get("selectedColumnsOnly"));
        this.fetchedRowsPolicy = fetchedRowsOnly || selectedRowsOnly || selectedColumnsOnly ? new FetchedRowsPolicy(selectedRowsOnly, selectedColumnsOnly) : null;
    }

    @Override
    public void saveSettings(Map<String, Object> settings) {
        settings.put("extractType", this.extractType.name());
        settings.put("segmentSize", this.segmentSize);
        settings.put("fetchSize", this.fetchSize);
        settings.put("openNewConnections", this.openNewConnections);
        settings.put("queryRowCount", this.queryRowCount);
        settings.put("fetchedRowsOnly", this.fetchedRowsPolicy != null);
        settings.put("selectedColumnsOnly", this.fetchedRowsPolicy != null && this.fetchedRowsPolicy.selectedColumnsOnly());
        settings.put("selectedRowsOnly", this.fetchedRowsPolicy != null && this.fetchedRowsPolicy.selectedRowsOnly());
    }

    @Override
    public String getSettingsSummary() {
        StringBuilder summary = new StringBuilder();
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_new_connection, this.openNewConnections);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_label_extract_type, this.extractType.name());
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_select_row_count, this.queryRowCount);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_fetched_rows_only, this.fetchedRowsPolicy != null);
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_selected_rows_only, this.fetchedRowsPolicy != null && this.fetchedRowsPolicy.selectedRowsOnly());
        DTUtils.addSummary(summary, DTMessages.data_transfer_wizard_output_checkbox_selected_columns_only, this.fetchedRowsPolicy != null && this.fetchedRowsPolicy.selectedColumnsOnly());
        return summary.toString();
    }

    public static enum ExtractType {
        SINGLE_QUERY,
        SEGMENTS;

    }

    public record FetchedRowsPolicy(boolean selectedRowsOnly, boolean selectedColumnsOnly) {
    }
}

