/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.data.office.export;

import java.util.Set;
import org.apache.poi.ss.usermodel.Workbook;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;

public class WorksheetUtils {
    private static final Log log = Log.getLog(WorksheetUtils.class);
    public static final String DEFAULT_SHEET_NAME = "CustomQuery";
    private static final Set<String> RESERVED_WORDS = Set.of("History");
    private static final int MAX_NAME_LENGTH = 31;
    private static final int MAX_NAME_GENERATION_ATTEMPTS = 1000;

    private WorksheetUtils() {
    }

    @NotNull
    public static String makeUniqueSheetName(@NotNull Workbook workbook, @Nullable String sheetName) {
        String name = WorksheetUtils.toValidExcelSheetName(sheetName);
        int i = 0;
        while (i < 1000) {
            Object result;
            if (i == 0) {
                result = name;
            } else {
                String suffix = String.valueOf(i);
                result = name.substring(0, Math.min(name.length(), 31 - suffix.length())) + suffix;
            }
            if (workbook.getSheet((String)result) == null) {
                return result;
            }
            ++i;
        }
        log.error((Object)"Unable to generate unique sheet name; using the original name instead");
        return name;
    }

    @NotNull
    private static String toValidExcelSheetName(@Nullable String originSheetName) {
        if (originSheetName == null) {
            return DEFAULT_SHEET_NAME;
        }
        String result = originSheetName;
        result = result.replaceAll("[\\\\/*\\[\\]:?]", "_");
        result = result.strip();
        result = result.replaceAll("^'+|'+$", "");
        if (RESERVED_WORDS.contains(result = result.substring(0, Math.min(result.length(), 31))) || result.isBlank()) {
            result = DEFAULT_SHEET_NAME;
        }
        return result;
    }
}

