/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.debug.internal.impl;

import java.io.Closeable;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.DBGBaseController;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.dbeaver.debug.DBGEvent;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.debug.DBGSessionInfo;
import org.jkiss.dbeaver.debug.DBGStackFrame;
import org.jkiss.dbeaver.debug.DBGVariable;
import org.jkiss.dbeaver.debug.jdbc.DBGJDBCSession;
import org.jkiss.dbeaver.ext.postgresql.debug.core.PostgreSqlDebugCore;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugAttachKind;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugBreakpointDescriptor;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugSessionInfo;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugStackFrame;
import org.jkiss.dbeaver.ext.postgresql.debug.internal.impl.PostgreDebugVariable;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDataSource;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreDatabase;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCCallableStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSource;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCDataSourceInfo;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCUtils;
import org.jkiss.dbeaver.model.runtime.AbstractJob;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.utils.CommonUtils;
import org.jkiss.utils.IOUtils;

public class PostgreDebugSession
extends DBGJDBCSession {
    private final JDBCExecutionContext controllerConnection;
    private int functionOid = -1;
    private int sessionId = -1;
    private PostgreDebugAttachKind attachKind = PostgreDebugAttachKind.UNKNOWN;
    private DBGSessionInfo sessionInfo;
    private volatile Job localWorkerJob = null;
    private PostgreDebugBreakpointDescriptor bpGlobal;
    private static final int LOCAL_WAIT_MS = 500;
    private static final int LOCAL_TIMEOT_MS = 50000;
    private static final String MAGIC_PORT = "PLDBGBREAK";
    private static final String SQL_CHECK_PLUGIN = "select 'Server version: ' || serverversionstr || '.\nProxy API version: ' ||  proxyapiver from pldbg_get_proxy_info()";
    private static final String SQL_ATTACH = "select pldbg_wait_for_target(?sessionid)";
    private static final String SQL_ATTACH_TO_PORT = "select pldbg_attach_to_port(?portnumber)";
    private static final String SQL_PREPARE_SLOT = " select pldbg_oid_debug(?objectid)";
    private static final String SQL_LISTEN = "select pldbg_create_listener() as sessionid";
    private static final String SQL_GET_SRC = "select pldbg_get_source(?sessionid,?oid)";
    private static final String SQL_GET_VARS = "select * from pldbg_get_variables(?sessionid)";
    private static final String SQL_SET_VAR = "select pldbg_deposit_value(?,?,?,?)";
    private static final String SQL_GET_STACK = "select * from pldbg_get_stack(?sessionid)";
    private static final String SQL_SELECT_FRAME = "select * from pldbg_select_frame(?sessionid,?frameno)";
    private static final String SQL_STEP_OVER = "select pldbg_step_over(?sessionid)";
    private static final String SQL_STEP_INTO = "select pldbg_step_into(?sessionid)";
    private static final String SQL_CONTINUE = "select pldbg_continue(?sessionid)";
    private static final String SQL_ABORT = "select pldbg_abort_target(?sessionid)";
    private static final String SQL_SET_GLOBAL_BREAKPOINT = "select pldbg_set_global_breakpoint(?sessionid, ?obj, ?line, ?target)";
    private static final String SQL_SET_BREAKPOINT = "select pldbg_set_breakpoint(?sessionid, ?obj, ?line)";
    private static final String SQL_DROP_BREAKPOINT = "select pldbg_drop_breakpoint(?sessionid, ?obj, ?line)";
    private static final String SQL_CURRENT_SESSION = "SELECT pid,usename,application_name,state,query\nFROM pg_stat_activity WHERE pid = pg_backend_pid()";
    private static final Log log = Log.getLog(PostgreDebugSession.class);

    PostgreDebugSession(DBRProgressMonitor monitor, DBGBaseController controller) throws DBGException {
        super(controller);
        log.debug((Object)"Creating controller session.");
        PostgreDataSource dataSource = (PostgreDataSource)controller.getDataSourceContainer().getDataSource();
        try {
            PostgreDatabase instance;
            log.debug((Object)"Controller session creating.");
            if (this.isGlobalSession(controller.getDebugConfiguration())) {
                instance = dataSource.getDefaultInstance();
            } else {
                PostgreProcedure function = PostgreSqlDebugCore.resolveFunction(monitor, controller.getDataSourceContainer(), controller.getDebugConfiguration());
                instance = function.getDatabase();
            }
            this.controllerConnection = instance.openIsolatedContext(monitor, "Debug controller session", null);
            log.debug((Object)"Debug controller session created.");
            JDBCDataSource src = (JDBCDataSource)this.controllerConnection.getDataSource();
            if (src instanceof PostgreDataSource) {
                PostgreDataSource pgSrc = (PostgreDataSource)src;
                log.debug((Object)String.format("Active user %s", instance.getMetaContext().getActiveUser()));
                log.debug((Object)String.format("Active schema %s", instance.getMetaContext().getDefaultSchema()));
                if (pgSrc.getInfo() instanceof JDBCDataSourceInfo) {
                    JDBCDataSourceInfo JDBCinfo = (JDBCDataSourceInfo)pgSrc.getInfo();
                    log.debug((Object)"------------DATABASE DRIVER INFO---------------");
                    log.debug((Object)String.format("Database Product Name %s", JDBCinfo.getDatabaseProductName()));
                    log.debug((Object)String.format("Database Product Version %s", JDBCinfo.getDatabaseProductVersion()));
                    log.debug((Object)String.format("Database Version %s", JDBCinfo.getDatabaseVersion()));
                    log.debug((Object)String.format("Driver Name %s", JDBCinfo.getDriverName()));
                    log.debug((Object)String.format("Driver Version %s", JDBCinfo.getDriverVersion()));
                    log.debug((Object)"-----------------------------------------------");
                } else {
                    log.debug((Object)"No additional Driver info");
                }
            } else {
                log.debug((Object)"Unknown Driver version");
            }
        }
        catch (DBException e) {
            log.debug((Object)String.format("Error creating debug session %s", e.getMessage()));
            throw new DBGException((Throwable)e, (DBPDataSource)dataSource);
        }
    }

    public JDBCExecutionContext getControllerConnection() {
        return this.controllerConnection;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PostgreDebugSessionInfo getSessionDescriptor(DBRProgressMonitor monitor, JDBCExecutionContext connection) throws DBGException {
        try {
            var3_3 = null;
            var4_6 = null;
            try {
                session = connection.openSession(monitor, DBCExecutionPurpose.UTIL, "Read session info");
                try {
                    var6_9 = null;
                    var7_11 = null;
                    try {
                        stmt = session.createStatement();
                        try {
                            var9_14 = null;
                            var10_16 = null;
                            try {
                                block25: {
                                    rs = stmt.executeQuery("SELECT pid,usename,application_name,state,query\nFROM pg_stat_activity WHERE pid = pg_backend_pid()");
                                    try {
                                        if (rs.next()) {
                                            pid = rs.getInt("pid");
                                            usename = rs.getString("usename");
                                            applicationName = rs.getString("application_name");
                                            state = rs.getString("state");
                                            query = rs.getString("query");
                                            v0 = new PostgreDebugSessionInfo(pid, usename, applicationName, state, query);
                                            if (rs == null) break block25;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var9_15) {
                                        if (rs == null) throw var9_15;
                                        rs.close();
                                        throw var9_15;
                                    }
                                    rs.close();
                                }
                                if (stmt == null) return v0;
                            }
                            catch (Throwable var10_17) {
                                if (var9_14 == null) {
                                    var9_14 = var10_17;
                                    throw var9_14;
                                }
                                if (var9_14 == var10_17) throw var9_14;
                                var9_14.addSuppressed(var10_17);
                                throw var9_14;
                            }
                        }
                        catch (Throwable var6_10) {
                            if (stmt == null) throw var6_10;
                            stmt.close();
                            throw var6_10;
                        }
                        stmt.close();
                        return v0;
                    }
                    catch (Throwable var7_12) {
                        if (var6_9 == null) {
                            var6_9 = var7_12;
                            throw var6_9;
                        }
                        if (var6_9 == var7_12) throw var6_9;
                        var6_9.addSuppressed(var7_12);
                        throw var6_9;
                    }
lbl-1000:
                    // 1 sources

                    {
                        throw new DBGException("Error getting session");
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable var4_7) {
                if (var3_3 == null) {
                    var3_3 = var4_7;
                    throw var3_3;
                }
                if (var3_3 == var4_7) throw var3_3;
                var3_3.addSuppressed(var4_7);
                throw var3_3;
            }
        }
        catch (SQLException e) {
            throw new DBGException("SQL error", (Throwable)e);
        }
    }

    @Nullable
    private Integer tryParsePortNumber(@Nullable String notice) {
        if (notice != null && notice.startsWith(MAGIC_PORT)) {
            try {
                Integer result = Integer.valueOf(notice.substring(MAGIC_PORT.length() + 1).trim());
                log.debug((Object)String.format("Catch local port number %d", result));
                return result;
            }
            catch (Exception e) {
                log.debug((Object)String.format("Error catching local port number %s", e.getMessage()));
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int attachToPort(@NotNull DBRProgressMonitor monitor, int localPortNumber) throws DBGException {
        sql = "select pldbg_attach_to_port(?portnumber)".replaceAll("\\?portnumber", String.valueOf(localPortNumber));
        PostgreDebugSession.log.debug((Object)String.format("Attach to local port number %d", new Object[]{localPortNumber}));
        try {
            var4_4 = null;
            var5_7 = null;
            try {
                session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Attach to port");
                try {
                    var7_10 = null;
                    var8_12 = null;
                    try {
                        stmt = session.createStatement();
                        try {
                            var10_15 = null;
                            var11_17 = null;
                            try {
                                block25: {
                                    rs = stmt.executeQuery(sql);
                                    try {
                                        if (rs.next()) {
                                            attResult = rs.getInt(1);
                                            PostgreDebugSession.log.debug((Object)String.format("Attached to local port %d", new Object[]{attResult}));
                                            v0 = attResult;
                                            if (rs == null) break block25;
                                        }
                                        ** GOTO lbl-1000
                                    }
                                    catch (Throwable var10_16) {
                                        if (rs == null) throw var10_16;
                                        rs.close();
                                        throw var10_16;
                                    }
                                    rs.close();
                                }
                                if (stmt == null) return v0;
                            }
                            catch (Throwable var11_18) {
                                if (var10_15 == null) {
                                    var10_15 = var11_18;
                                    throw var10_15;
                                }
                                if (var10_15 == var11_18) throw var10_15;
                                var10_15.addSuppressed(var11_18);
                                throw var10_15;
                            }
                        }
                        catch (Throwable var7_11) {
                            if (stmt == null) throw var7_11;
                            stmt.close();
                            throw var7_11;
                        }
                        stmt.close();
                        return v0;
                    }
                    catch (Throwable var8_13) {
                        if (var7_10 == null) {
                            var7_10 = var8_13;
                            throw var7_10;
                        }
                        if (var7_10 == var8_13) throw var7_10;
                        var7_10.addSuppressed(var8_13);
                        throw var7_10;
                    }
lbl-1000:
                    // 1 sources

                    {
                        PostgreDebugSession.log.debug((Object)"Error while attaching to port");
                        throw new DBGException("Error while attaching to port");
                    }
                }
                finally {
                    if (session != null) {
                        session.close();
                    }
                }
            }
            catch (Throwable var5_8) {
                if (var4_4 == null) {
                    var4_4 = var5_8;
                    throw var4_4;
                }
                if (var4_4 == var5_8) throw var4_4;
                var4_4.addSuppressed(var5_8);
                throw var4_4;
            }
        }
        catch (SQLException e) {
            PostgreDebugSession.log.debug((Object)"Error while attaching to port");
            throw new DBGException("Error attaching to port", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String createSlot(DBRProgressMonitor monitor, JDBCExecutionContext connection, PostgreProcedure function) throws DBGException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private Integer waitPortNumber(@NotNull CompletableFuture<JDBCCallableStatement> asyncStatement) throws DBGException {
        int totalWaitMs = 0;
        log.debug((Object)String.format("Waiting for port number with timeout %d", 50000));
        try {
            CallableStatement statement = (CallableStatement)asyncStatement.get();
            log.debug((Object)"Start local port waiting....");
            SQLWarning warn = null;
            while (!statement.isClosed() && totalWaitMs < 50000 && warn == null) {
                warn = statement.getWarnings();
                if (warn != null) continue;
                Thread.sleep(500L);
                totalWaitMs += 500;
            }
            if (warn != null) {
                log.debug((Object)"First warning received");
                do {
                    log.debug((Object)String.format("Parsing warning %s", warn.getMessage()));
                    Integer localPort = this.tryParsePortNumber(warn.getMessage());
                    if (localPort != null) {
                        log.debug((Object)"Local port obtained");
                        return localPort;
                    }
                    log.debug((Object)String.format("Waiting for the next warning %s", warn.getMessage()));
                    SQLWarning nextWarn = null;
                    while (!statement.isClosed() && totalWaitMs < 50000 && nextWarn == null) {
                        nextWarn = warn.getNextWarning();
                        if (nextWarn != null) continue;
                        Thread.sleep(500L);
                        totalWaitMs += 500;
                    }
                    warn = nextWarn;
                } while (!statement.isClosed() && totalWaitMs < 50000);
            }
        }
        catch (InterruptedException | SQLException | ExecutionException e) {
            log.debug((Object)String.format("Error rcv port number %s", e.getMessage()));
            throw new DBGException("Error rcv port number", (Throwable)e);
        }
        log.debug((Object)"Unable to rcv port number");
        throw new DBGException("Unable to rcv port number");
    }

    @NotNull
    protected Job runLocalProc(final @NotNull JDBCExecutionContext connection, final @NotNull PostgreProcedure function, final @NotNull List<String> paramValues, final @NotNull String name, final @NotNull CompletableFuture<JDBCCallableStatement> asyncStatement) throws DBGException {
        final List parameters = function.getInputParameters();
        log.debug((Object)"Run local proc");
        if (parameters.size() != paramValues.size()) {
            String unmatched = "Parameter value count (" + paramValues.size() + ") doesn't match actual function parameters (" + parameters.size() + ")";
            log.debug((Object)unmatched);
            throw new DBGException(unmatched);
        }
        AbstractJob job = new AbstractJob(name){
            private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$DBPDataKind;

            /*
             * Exception decompiling
             */
            protected IStatus run(DBRProgressMonitor monitor) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            static /* synthetic */ int[] $SWITCH_TABLE$org$jkiss$dbeaver$model$DBPDataKind() {
                if ($SWITCH_TABLE$org$jkiss$dbeaver$model$DBPDataKind != null) {
                    return $SWITCH_TABLE$org$jkiss$dbeaver$model$DBPDataKind;
                }
                int[] nArray = new int[DBPDataKind.values().length];
                try {
                    nArray[DBPDataKind.ANY.ordinal()] = 13;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.ARRAY.ordinal()] = 9;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.BINARY.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.BOOLEAN.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.CONTENT.ordinal()] = 6;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.DATETIME.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.DOCUMENT.ordinal()] = 8;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.NUMERIC.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.OBJECT.ordinal()] = 10;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.REFERENCE.ordinal()] = 11;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.ROWID.ordinal()] = 12;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.STRING.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.STRUCT.ordinal()] = 7;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                try {
                    nArray[DBPDataKind.UNKNOWN.ordinal()] = 14;
                }
                catch (NoSuchFieldError noSuchFieldError) {}
                $SWITCH_TABLE$org$jkiss$dbeaver$model$DBPDataKind = nArray;
                return nArray;
            }
        };
        job.schedule();
        return job;
    }

    private void attachLocal(DBRProgressMonitor monitor, PostgreProcedure function, List<String> parameters) throws DBGException {
        try {
            JDBCExecutionContext connection = (JDBCExecutionContext)this.controllerConnection.getOwnerInstance().openIsolatedContext(monitor, "Debug process session", null);
            log.debug((Object)"Attaching locally....");
            this.sessionInfo = this.getSessionDescriptor(monitor, connection);
            this.createSlot(monitor, connection, function);
            String taskName = "PostgreSQL Debug - Local session " + String.valueOf(this.sessionInfo.getID());
            CompletableFuture<JDBCCallableStatement> asyncStatement = new CompletableFuture<JDBCCallableStatement>();
            this.localWorkerJob = this.runLocalProc(connection, function, parameters, taskName, asyncStatement);
            Integer portNumber = this.waitPortNumber(asyncStatement);
            this.sessionId = this.attachToPort(monitor, portNumber);
            log.debug((Object)String.format("Attached local session UD = %d", this.sessionId));
            this.getController().fireEvent(new DBGEvent((Object)this, 2, 32));
        }
        catch (DBException e) {
            throw new DBGException("Error opening debug session", (Throwable)e);
        }
    }

    private void attachGlobal(DBRProgressMonitor monitor, int oid, int targetPID) throws DBGException {
        block30: {
            log.debug((Object)"Attaching globally....");
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Attach global");){
                    Throwable throwable2 = null;
                    Object var8_12 = null;
                    try (JDBCStatement stmt = session.createStatement();){
                        Throwable throwable3 = null;
                        Object var11_17 = null;
                        try (ResultSet rs = stmt.executeQuery(SQL_LISTEN);){
                            if (rs.next()) {
                                this.sessionId = rs.getInt("sessionid");
                                log.debug((Object)String.format("Global session ID %d", this.sessionId));
                                break block30;
                            }
                            log.debug((Object)"Unable to create debug instance");
                            throw new DBGException("Unable to create debug instance");
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Throwable throwable5) {
                        if (throwable2 == null) {
                            throwable2 = throwable5;
                        } else if (throwable2 != throwable5) {
                            throwable2.addSuppressed(throwable5);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable6) {
                    if (throwable == null) {
                        throwable = throwable6;
                    } else if (throwable != throwable6) {
                        throwable.addSuppressed(throwable6);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                throw new DBGException("SQL error", (Throwable)e);
            }
        }
        this.bpGlobal = new PostgreDebugBreakpointDescriptor(oid, -1L);
        this.addBreakpoint(monitor, this.bpGlobal);
        log.debug((Object)"Global breakpoint added");
        String sessionParam = String.valueOf(this.getSessionId());
        String taskName = "PostgreSQL Debug - Global session " + sessionParam;
        String sql = SQL_ATTACH.replaceAll("\\?sessionid", sessionParam);
        DBGEvent begin = new DBGEvent((Object)this, 1, 32);
        DBGEvent end = new DBGEvent((Object)this, 2, 16);
        this.runAsync(sql, taskName, begin, end);
        log.debug((Object)"Global session started");
    }

    public void attach(DBRProgressMonitor monitor, Map<String, Object> configuration) throws DBException {
        if (!this.checkDebugPlugin(monitor)) {
            throw new DBGException("PostgreSQL debug plugin is not installed on the server.\nRefer to this WIKI article for installation instructions:\nhttps://github.com/dbeaver/dbeaver/wiki/PGDebugger#installation");
        }
        log.debug((Object)"Attaching...");
        this.functionOid = CommonUtils.toInt((Object)configuration.get("PG.ATTR_FUNCTION_OID"));
        log.debug((Object)String.format("Function OID %d", this.functionOid));
        boolean global = this.isGlobalSession(configuration);
        if (global) {
            int processId = CommonUtils.toInt((Object)configuration.get("PG.ATTACH_PROCESS"));
            this.attachKind = PostgreDebugAttachKind.GLOBAL;
            this.attachGlobal(monitor, this.functionOid, processId);
            log.debug((Object)"Global attached");
        } else {
            this.attachKind = PostgreDebugAttachKind.LOCAL;
            PostgreProcedure function = PostgreSqlDebugCore.resolveFunction(monitor, ((JDBCDataSource)this.controllerConnection.getDataSource()).getContainer(), configuration);
            List parameterValues = (List)configuration.get("PG.ATTR_FUNCTION_PARAMETERS");
            this.attachLocal(monitor, function, parameterValues);
            log.debug((Object)"Local attached");
        }
    }

    private boolean isGlobalSession(Map<String, Object> configuration) {
        return "GLOBAL".equals(String.valueOf(configuration.get("PG.ATTR_ATTACH_KIND")));
    }

    private boolean checkDebugPlugin(DBRProgressMonitor monitor) {
        block12: {
            Throwable throwable = null;
            Object var3_5 = null;
            JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Check debug plugin installation");
            try {
                String version = (String)JDBCUtils.executeQuery((Connection)session, (String)SQL_CHECK_PLUGIN, (Object[])new Object[0]);
                log.debug((Object)("Debug plugin is installed:\n" + version));
                if (session == null) break block12;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        if (session != null) {
                            session.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (Exception e) {
                    log.debug((Object)("Debug plugin not installed: " + e.getMessage()));
                    return false;
                }
            }
            session.close();
        }
        return true;
    }

    private void detachLocal(DBRProgressMonitor monitor, JDBCExecutionContext connection) throws DBGException {
        if (this.localWorkerJob == null || Status.OK_STATUS.equals(this.localWorkerJob.getResult())) {
            return;
        }
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = connection.openSession(monitor, DBCExecutionPurpose.UTIL, "Abort local session");){
                JDBCUtils.executeQuery((Connection)session, (String)this.composeAbortCommand(), (Object[])new Object[0]);
                log.debug((Object)"Local detached");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)"Unable to abort local session");
            log.error((Object)"Unable to abort local target", (Throwable)e);
        }
    }

    private void detachGlobal(DBRProgressMonitor monitor) throws DBGException {
        this.removeBreakpoint(monitor, this.bpGlobal);
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Abort global session");){
                JDBCUtils.executeQuery((Connection)session, (String)this.composeAbortCommand(), (Object[])new Object[0]);
                log.debug((Object)"Global deattached");
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.error((Object)"Unable to abort global target", (Throwable)e);
        }
    }

    protected void doDetach(DBRProgressMonitor monitor) throws DBGException {
        switch (this.attachKind) {
            case GLOBAL: {
                this.detachGlobal(monitor);
                break;
            }
            case LOCAL: {
                this.detachLocal(monitor, this.getControllerConnection());
                break;
            }
        }
    }

    public DBGSessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    protected String composeAddBreakpointCommand(DBGBreakpointDescriptor descriptor) {
        PostgreDebugBreakpointDescriptor bp = (PostgreDebugBreakpointDescriptor)descriptor;
        String sqlPattern = this.attachKind == PostgreDebugAttachKind.GLOBAL ? SQL_SET_GLOBAL_BREAKPOINT : SQL_SET_BREAKPOINT;
        long lineNumber = bp.isOnStart() ? -1L : bp.getLineNo();
        log.debug((Object)String.format("Adding breakpoint to line #%d", lineNumber));
        return sqlPattern.replaceAll("\\?sessionid", String.valueOf(this.getSessionId())).replaceAll("\\?obj", String.valueOf(this.functionOid)).replaceAll("\\?line", String.valueOf(lineNumber)).replaceAll("\\?target", bp.isAll() ? "null" : String.valueOf(bp.getTargetId()));
    }

    protected String composeRemoveBreakpointCommand(DBGBreakpointDescriptor breakpointDescriptor) {
        PostgreDebugBreakpointDescriptor bp = (PostgreDebugBreakpointDescriptor)breakpointDescriptor;
        return SQL_DROP_BREAKPOINT.replaceAll("\\?sessionid", String.valueOf(this.getSessionId())).replaceAll("\\?obj", String.valueOf(this.functionOid)).replaceAll("\\?line", bp.isOnStart() ? "-1" : String.valueOf(bp.getLineNo()));
    }

    public void execContinue() throws DBGException {
        log.debug((Object)"try continue for");
        this.execStep(SQL_CONTINUE, " continue for ", 1);
        log.debug((Object)"continue for realized");
    }

    public void execStepInto() throws DBGException {
        log.debug((Object)"try step into");
        this.execStep(SQL_STEP_INTO, " step into for ", 1);
        log.debug((Object)"step into realized");
    }

    public void execStepOver() throws DBGException {
        log.debug((Object)"try step over");
        this.execStep(SQL_STEP_OVER, " step over for ", 2);
        log.debug((Object)"step over realized");
    }

    public void execStepReturn() throws DBGException {
        log.debug((Object)"Exec return not implemented");
        throw new DBGException("Exec return not implemented");
    }

    public void resume() throws DBGException {
        log.debug((Object)"try continue execution");
        this.execContinue();
        log.debug((Object)"continue execution realized");
    }

    public void suspend() throws DBGException {
        throw new DBGException("Suspend not implemented");
    }

    public void execStep(String commandPattern, String nameParameter, int eventDetail) throws DBGException {
        String sql = commandPattern.replaceAll("\\?sessionid", String.valueOf(this.sessionId));
        String taskName = String.valueOf(this.sessionId) + nameParameter + String.valueOf(this.sessionInfo.getID());
        DBGEvent begin = new DBGEvent((Object)this, 1, eventDetail);
        DBGEvent end = new DBGEvent((Object)this, 2, eventDetail);
        this.runAsync(sql, taskName, begin, end);
    }

    protected String composeAbortCommand() {
        return SQL_ABORT.replaceAll("\\?sessionid", String.valueOf(this.sessionId));
    }

    public List<DBGVariable<?>> getVariables(DBGStackFrame stack) throws DBGException {
        if (stack != null) {
            this.selectFrame(stack.getLevel());
        }
        log.debug((Object)"Get vars values");
        ArrayList vars = new ArrayList();
        String sql = SQL_GET_VARS.replaceAll("\\?sessionid", String.valueOf(this.sessionId));
        try {
            Throwable throwable = null;
            Object var5_7 = null;
            try (JDBCSession session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Read debug variables");){
                Throwable throwable2 = null;
                Object var8_12 = null;
                try (JDBCStatement stmt = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var11_17 = null;
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        while (rs.next()) {
                            String name = rs.getString("name");
                            String varclass = rs.getString("varclass");
                            int linenumber = rs.getInt("linenumber");
                            boolean isunique = rs.getBoolean("isunique");
                            boolean isconst = rs.getBoolean("isconst");
                            boolean isnotnull = rs.getBoolean("isnotnull");
                            int dtype = rs.getInt("dtype");
                            String value = rs.getString("value");
                            PostgreDebugVariable var = new PostgreDebugVariable(name, varclass, linenumber, isunique, isconst, isnotnull, dtype, value);
                            vars.add(var);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)("Error getting vars: " + e.getMessage()));
            throw new DBGException("SQL error", (Throwable)e);
        }
        log.debug((Object)String.format("Return %d var(s)", vars.size()));
        return vars;
    }

    public void setVariableVal(DBGVariable<?> variable, Object value) throws DBGException {
        block22: {
            log.debug((Object)"Set var value");
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (JDBCSession session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Set debug variable");){
                    Throwable throwable2 = null;
                    Object var7_11 = null;
                    try (JDBCPreparedStatement stmt = session.prepareStatement(SQL_SET_VAR);){
                        if (variable instanceof PostgreDebugVariable) {
                            if (value instanceof String) {
                                PostgreDebugVariable var = (PostgreDebugVariable)variable;
                                stmt.setInt(1, this.sessionId);
                                stmt.setString(2, var.getName());
                                stmt.setInt(3, var.getLineNumber());
                                stmt.setString(4, (String)value);
                                stmt.execute();
                                log.debug((Object)"Var value set");
                                break block22;
                            }
                            log.debug((Object)"Incorrect variable value class");
                            throw new DBGException("Incorrect variable value class");
                        }
                        log.debug((Object)"Incorrect variable class");
                        throw new DBGException("Incorrect variable class");
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                log.debug((Object)("Error setting var: " + e.getMessage()));
                throw new DBGException("SQL error", (Throwable)e);
            }
        }
    }

    public List<DBGStackFrame> getStack() throws DBGException {
        ArrayList<DBGStackFrame> stack = new ArrayList<DBGStackFrame>(1);
        log.debug((Object)"Get stack");
        String sql = SQL_GET_STACK.replaceAll("\\?sessionid", String.valueOf(this.getSessionId()));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Get debug stack frame");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement stmt = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        while (rs.next()) {
                            int level = rs.getInt("level");
                            String targetname = rs.getString("targetname");
                            int func = rs.getInt("func");
                            int linenumber = rs.getInt("linenumber");
                            String args = rs.getString("args");
                            PostgreDebugStackFrame frame = new PostgreDebugStackFrame(level, targetname, func, linenumber, args);
                            stack.add(frame);
                        }
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)("Error loading stack frame: " + e.getMessage()));
            throw new DBGException("SQL error", (Throwable)e);
        }
        log.debug((Object)String.format("Return %d stack frame(s)", stack.size()));
        return stack;
    }

    public String getSource(DBGStackFrame stack) throws DBGException {
        log.debug((Object)"Get source");
        if (stack instanceof PostgreDebugStackFrame) {
            PostgreDebugStackFrame postgreStack = (PostgreDebugStackFrame)stack;
            String src = this.getSource(postgreStack.getOid());
            log.debug((Object)String.format("Return %d src char(s)", src.length()));
            return src;
        }
        String message = String.format("Unable to get source for stack %s", stack);
        throw new DBGException(message);
    }

    /*
     * Exception decompiling
     */
    public String getSource(int OID) throws DBGException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void selectFrame(int frameNumber) throws DBGException {
        log.debug((Object)"Select frame");
        String sql = SQL_SELECT_FRAME.replaceAll("\\?sessionid", String.valueOf(this.sessionId)).replaceAll("\\?frameno", String.valueOf(frameNumber));
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (JDBCSession session = this.getControllerConnection().openSession((DBRProgressMonitor)new VoidProgressMonitor(), DBCExecutionPurpose.UTIL, "Select debug frame");){
                Throwable throwable2 = null;
                Object var7_11 = null;
                try (JDBCStatement stmt = session.createStatement();){
                    Throwable throwable3 = null;
                    Object var10_16 = null;
                    try (ResultSet rs = stmt.executeQuery(sql);){
                        if (!rs.next()) {
                            log.debug((Object)"Unable to select frame");
                            throw new DBGException("Unable to select frame");
                        }
                        log.debug((Object)"Frame selected");
                    }
                    catch (Throwable throwable4) {
                        if (throwable3 == null) {
                            throwable3 = throwable4;
                        } else if (throwable3 != throwable4) {
                            throwable3.addSuppressed(throwable4);
                        }
                        throw throwable3;
                    }
                }
                catch (Throwable throwable5) {
                    if (throwable2 == null) {
                        throwable2 = throwable5;
                    } else if (throwable2 != throwable5) {
                        throwable2.addSuppressed(throwable5);
                    }
                    throw throwable2;
                }
            }
            catch (Throwable throwable6) {
                if (throwable == null) {
                    throwable = throwable6;
                } else if (throwable != throwable6) {
                    throwable.addSuppressed(throwable6);
                }
                throw throwable;
            }
        }
        catch (SQLException e) {
            log.debug((Object)String.format("Unable to select frame %s", e.getMessage()));
            throw new DBGException("SQL error", (Throwable)e);
        }
    }

    public String toString() {
        return "PostgreDebugSession " + (this.isWaiting() ? "WAITING" : "READY") + " [sessionId=" + this.sessionId + ", breakpoints=" + String.valueOf(this.getBreakpoints()) + "targetId=(" + String.valueOf(this.sessionInfo.getID()) + ") Session=(" + this.sessionInfo.toString() + ") ]";
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public boolean canStepInto() {
        return true;
    }

    public boolean canStepOver() {
        return true;
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isAttached() {
        return this.sessionId > 0;
    }

    public boolean isDone() {
        switch (this.attachKind) {
            case GLOBAL: {
                return this.workerJob == null || this.workerJob.isFinished();
            }
            case LOCAL: {
                return this.sessionId > 0;
            }
        }
        return false;
    }

    public void closeSession(DBRProgressMonitor monitor) throws DBGException {
        if (!this.isAttached()) {
            return;
        }
        log.debug((Object)"Closing session.");
        try {
            super.closeSession(monitor);
            log.debug((Object)"Session closed.");
        }
        finally {
            if (this.controllerConnection != null) {
                IOUtils.close((Closeable)this.controllerConnection);
            }
        }
    }

    static /* synthetic */ void access$1(PostgreDebugSession postgreDebugSession, DBGEvent dBGEvent) {
        postgreDebugSession.fireEvent(dBGEvent);
    }
}

