/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui.details;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.action.LegacyActionTools;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IPropertyListener;

public abstract class DatabaseDebugDetailEditor {
    private ListenerList<IPropertyListener> listeners = new ListenerList();
    private boolean dirty = false;
    private boolean mnemonics = true;
    private boolean suppressPropertyChanges = false;

    public abstract Control createControl(Composite var1);

    public abstract void setFocus();

    public abstract Object getInput();

    public abstract void setInput(Object var1) throws CoreException;

    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(int propId) {
        this.dirty = true;
        this.firePropertyChange(propId);
    }

    protected void setDirty(boolean dirty) {
        if (this.dirty != dirty) {
            this.dirty = dirty;
            this.firePropertyChange(257);
        }
    }

    public abstract void doSave() throws CoreException;

    public abstract IStatus getStatus();

    protected void dispose() {
        this.listeners.clear();
    }

    public void addPropertyListener(IPropertyListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removePropertyListener(IPropertyListener listener) {
        this.listeners.remove((Object)listener);
    }

    protected void firePropertyChange(int propId) {
        if (!this.suppressPropertyChanges) {
            for (IPropertyListener listener : this.listeners) {
                listener.propertyChanged((Object)this, propId);
            }
        }
    }

    protected void suppressPropertyChanges(boolean suppress) {
        this.suppressPropertyChanges = suppress;
    }

    public void setMnemonics(boolean mnemonics) {
        this.mnemonics = mnemonics;
    }

    protected boolean isMnemonics() {
        return this.mnemonics;
    }

    protected String processMnemonics(String text) {
        if (this.isMnemonics()) {
            return text;
        }
        return LegacyActionTools.removeMnemonics((String)text);
    }
}

