/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.sql.execute;

import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.update.Update;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBFetchProgress;
import org.jkiss.dbeaver.model.DBPDataKind;
import org.jkiss.dbeaver.model.DBPDataSource;
import org.jkiss.dbeaver.model.DBPDataSourceInfo;
import org.jkiss.dbeaver.model.DBPErrorAssistant;
import org.jkiss.dbeaver.model.DBUtils;
import org.jkiss.dbeaver.model.connection.DBPConnectionType;
import org.jkiss.dbeaver.model.data.DBDDataFilter;
import org.jkiss.dbeaver.model.data.DBDDataReceiver;
import org.jkiss.dbeaver.model.exec.DBCAttributeMetaData;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.DBCExecutionSource;
import org.jkiss.dbeaver.model.exec.DBCResultSet;
import org.jkiss.dbeaver.model.exec.DBCResultSetMetaData;
import org.jkiss.dbeaver.model.exec.DBCScriptContext;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.DBCStatement;
import org.jkiss.dbeaver.model.exec.DBCStatementType;
import org.jkiss.dbeaver.model.exec.DBCStatistics;
import org.jkiss.dbeaver.model.exec.DBCTransactionManager;
import org.jkiss.dbeaver.model.exec.DBExecUtils;
import org.jkiss.dbeaver.model.impl.AbstractExecutionSource;
import org.jkiss.dbeaver.model.impl.AbstractStatement;
import org.jkiss.dbeaver.model.impl.local.LocalStatement;
import org.jkiss.dbeaver.model.impl.local.StatResultSet;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.qm.QMUtils;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableParametrized;
import org.jkiss.dbeaver.model.sql.SQLControlCommand;
import org.jkiss.dbeaver.model.sql.SQLControlResult;
import org.jkiss.dbeaver.model.sql.SQLDialect;
import org.jkiss.dbeaver.model.sql.SQLQuery;
import org.jkiss.dbeaver.model.sql.SQLQueryListener;
import org.jkiss.dbeaver.model.sql.SQLQueryResult;
import org.jkiss.dbeaver.model.sql.SQLQueryType;
import org.jkiss.dbeaver.model.sql.SQLScriptCommitType;
import org.jkiss.dbeaver.model.sql.SQLScriptContext;
import org.jkiss.dbeaver.model.sql.SQLScriptElement;
import org.jkiss.dbeaver.model.sql.SQLScriptErrorHandling;
import org.jkiss.dbeaver.model.sql.SqlJobResult;
import org.jkiss.dbeaver.model.sql.data.SQLQueryDataContainer;
import org.jkiss.dbeaver.model.sql.parser.SQLSemanticProcessor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandHandlerDescriptor;
import org.jkiss.dbeaver.model.sql.registry.SQLCommandsRegistry;
import org.jkiss.dbeaver.model.sql.registry.SQLPragmaHandlerDescriptor;
import org.jkiss.dbeaver.model.struct.DBSDataContainer;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.runtime.jobs.DataSourceJob;
import org.jkiss.dbeaver.runtime.ui.DBPPlatformUI;
import org.jkiss.dbeaver.tools.transfer.IDataTransferConsumer;
import org.jkiss.dbeaver.ui.ISmartTransactionManager;
import org.jkiss.dbeaver.ui.UITask;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.dialogs.ConfirmationDialog;
import org.jkiss.dbeaver.ui.dialogs.exec.ExecutionQueueErrorJob;
import org.jkiss.dbeaver.ui.editors.IncludedScriptFileEditorInput;
import org.jkiss.dbeaver.ui.editors.sql.SQLPreferenceConstants;
import org.jkiss.dbeaver.ui.editors.sql.SQLResultsConsumer;
import org.jkiss.dbeaver.ui.editors.sql.internal.SQLEditorMessages;
import org.jkiss.dbeaver.utils.RuntimeUtils;
import org.jkiss.utils.CommonUtils;

public class SQLQueryJob
extends DataSourceJob {
    private static final Log log = Log.getLog(SQLQueryJob.class);
    public static final Object STATS_RESULTS = new Object();
    private static final int MAX_QUERY_PREVIEW_LENGTH = 8192;
    private static final int MAX_UPDATE_COUNT_READS = 1000;
    private final DBSDataContainer dataContainer;
    private final List<SQLScriptElement> queries;
    private final SQLScriptContext scriptContext;
    private final SQLResultsConsumer resultsConsumer;
    private final SQLQueryListener listener;
    private final IWorkbenchPartSite partSite;
    private DBDDataFilter dataFilter;
    private boolean connectionInvalidated = false;
    private final SQLScriptCommitType commitType;
    private SQLScriptErrorHandling errorHandling;
    private boolean fetchResultSets;
    private long rsOffset;
    private long rsMaxRows;
    private DBCStatement curStatement;
    private final List<DBCResultSet> curResultSets = new ArrayList<DBCResultSet>();
    private Throwable lastError = null;
    private DBCStatistics statistics;
    private int fetchResultSetNumber;
    private int resultSetNumber;
    private SQLScriptElement lastGoodQuery;
    private int queryNum = 0;
    private boolean skipConfirmation;
    private int fetchSize;
    private long fetchFlags;
    private SQLQueryResult curResult;
    private transient int rowsFetched;

    public SQLQueryJob(@NotNull IWorkbenchPartSite partSite, @NotNull String name, @NotNull DBCExecutionContext executionContext, @Nullable DBSDataContainer dataContainer, @NotNull List<SQLScriptElement> queries, @NotNull SQLScriptContext scriptContext, @Nullable SQLResultsConsumer resultsConsumer, @Nullable SQLQueryListener listener, boolean isDisableFetchResultSet) {
        super(name, executionContext);
        this.dataContainer = dataContainer;
        this.partSite = partSite;
        this.queries = queries;
        this.scriptContext = scriptContext;
        this.resultsConsumer = resultsConsumer;
        this.listener = listener;
        DBPPreferenceStore preferenceStore = this.getDataSourceContainer().getPreferenceStore();
        this.commitType = SQLScriptCommitType.valueOf((String)preferenceStore.getString("script.commit.type"));
        this.errorHandling = SQLScriptErrorHandling.valueOf((String)preferenceStore.getString("script.error.handling"));
        this.fetchResultSets = queries.size() == 1 || preferenceStore.getBoolean("script.fetch.resultset") && !isDisableFetchResultSet;
        this.rsMaxRows = preferenceStore.getInt("resultset.maxrows");
    }

    public String toString() {
        return "SQLQueryJob (" + String.valueOf(this.queries) + ")";
    }

    public void setFetchResultSets(boolean fetchResultSets) {
        this.fetchResultSets = fetchResultSets;
    }

    public SQLScriptElement getLastQuery() {
        return this.queries.isEmpty() ? null : this.queries.getFirst();
    }

    public SQLScriptElement getLastGoodQuery() {
        return this.lastGoodQuery;
    }

    public DBCStatement getCurrentStatement() {
        return this.curStatement;
    }

    public SQLQueryResult getCurrentQueryResult() {
        return this.curResult;
    }

    private boolean hasLimits() {
        return this.rsOffset >= 0L && this.rsMaxRows > 0L;
    }

    public void setResultSetLimit(long offset, long maxRows) {
        this.rsOffset = offset;
        this.rsMaxRows = maxRows;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void setFetchFlags(long fetchFlags) {
        this.fetchFlags = fetchFlags;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    protected IStatus run(@NotNull DBRProgressMonitor monitor) {
        Status status;
        DBCSession session;
        block45: {
            boolean newAutoCommit;
            RuntimeUtils.setThreadName((String)"SQL script execution");
            this.statistics = new DBCStatistics();
            this.skipConfirmation = false;
            if (this.queryNum == this.queries.size()) {
                this.queryNum = 0;
            }
            monitor.beginTask("Execute SQL script", this.queries.size());
            DBCExecutionContext context = this.getExecutionContext();
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)context);
            DBCExecutionPurpose purpose = this.queries.size() > 1 ? DBCExecutionPurpose.USER_SCRIPT : DBCExecutionPurpose.USER;
            session = context.openSession(monitor, purpose, "SQL Query");
            if (session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleScriptBegin(session);
            }
            boolean oldAutoCommit = txnManager == null || txnManager.isAutoCommit();
            boolean bl = newAutoCommit = this.commitType == SQLScriptCommitType.AUTOCOMMIT;
            if (txnManager != null && !oldAutoCommit && newAutoCommit) {
                txnManager.setAutoCommit(monitor, true);
            }
            monitor.beginTask(this.getName(), this.queries.size());
            if (this.listener != null) {
                try {
                    this.listener.onStartScript();
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
            }
            this.resultSetNumber = 0;
            while (this.queryNum < this.queries.size()) {
                SQLScriptElement query = this.queries.get(this.queryNum);
                this.fetchResultSetNumber = this.resultSetNumber;
                boolean runNext = this.executeSingleQuery(session, query, true);
                if (txnManager != null && txnManager.isSupportsTransactions() && !oldAutoCommit && this.commitType != SQLScriptCommitType.AUTOCOMMIT && query instanceof SQLQuery) {
                    SQLQuery sqlQuery = (SQLQuery)query;
                    this.handleTransactionStatements(txnManager, session, sqlQuery);
                }
                if (!runNext) {
                    if (this.lastError == null) break;
                    log.error((Object)this.lastError);
                    boolean isQueue = this.isQueue();
                    DBPPlatformUI.UserResponse response = ExecutionQueueErrorJob.showError((String)(isQueue ? "SQL script execution" : "SQL query execution"), (Throwable)this.lastError, (boolean)isQueue);
                    boolean stopScript = false;
                    boolean tryAgain = false;
                    switch (response) {
                        case STOP: {
                            stopScript = true;
                            break;
                        }
                        case RETRY: {
                            tryAgain = true;
                            break;
                        }
                        case IGNORE: {
                            this.lastError = null;
                            break;
                        }
                        case IGNORE_ALL: {
                            this.lastError = null;
                            this.errorHandling = SQLScriptErrorHandling.IGNORE;
                        }
                    }
                    if (stopScript) break;
                    if (tryAgain) {
                        RuntimeUtils.pause((int)100);
                        continue;
                    }
                }
                if (monitor.isCanceled()) break;
                monitor.worked(1);
                ++this.queryNum;
            }
            if (this.statistics.getStatementsCount() > 0) {
                this.showExecutionResult(session);
            }
            monitor.done();
            if (txnManager != null && txnManager.isSupportsTransactions() && !oldAutoCommit && this.commitType != SQLScriptCommitType.AUTOCOMMIT) {
                if (this.lastError == null || this.errorHandling == SQLScriptErrorHandling.STOP_COMMIT) {
                    if (this.commitType != SQLScriptCommitType.NO_COMMIT) {
                        monitor.beginTask("Commit data", 1);
                        txnManager.commit(session);
                        monitor.done();
                    }
                } else if (this.errorHandling == SQLScriptErrorHandling.STOP_ROLLBACK) {
                    monitor.beginTask("Rollback data", 1);
                    txnManager.rollback(session, null);
                    monitor.done();
                } else {
                    log.info((Object)"Script executed with errors. Changes were not committed.");
                }
            }
            if (txnManager != null && !oldAutoCommit && newAutoCommit) {
                txnManager.setAutoCommit(monitor, false);
            }
            if (session.isLoggingEnabled()) {
                QMUtils.getDefaultHandler().handleScriptEnd(session);
            }
            if (this.listener != null) {
                this.listener.onEndSqlJob(session, this.getSqlJobResult());
            }
            status = new Status(0, "org.jkiss.dbeaver.ui.editors.sql", "SQL job completed");
            if (session == null) break block45;
            session.close();
        }
        monitor.done();
        if (this.listener != null) {
            try {
                this.listener.onEndScript(this.statistics, this.lastError != null);
            }
            catch (Exception e) {
                log.error((Object)e);
            }
        }
        return status;
        {
            catch (Throwable throwable) {
                try {
                    try {
                        if (session != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Throwable ex) {
                        Status status2 = new Status(4, "org.jkiss.dbeaver.ui.editors.sql", "Error during SQL job execution: " + ex.getMessage());
                        monitor.done();
                        if (this.listener != null) {
                            try {
                                this.listener.onEndScript(this.statistics, this.lastError != null);
                            }
                            catch (Exception e) {
                                log.error((Object)e);
                            }
                        }
                        return status2;
                    }
                }
                catch (Throwable throwable3) {
                    monitor.done();
                    if (this.listener != null) {
                        try {
                            this.listener.onEndScript(this.statistics, this.lastError != null);
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                        }
                    }
                    throw throwable3;
                }
            }
        }
    }

    private boolean isQueue() {
        IEditorPart ep;
        IWorkbenchPart iWorkbenchPart = this.partSite.getPart();
        boolean isIncludedScript = iWorkbenchPart instanceof IEditorPart && (ep = (IEditorPart)iWorkbenchPart).getEditorInput() instanceof IncludedScriptFileEditorInput;
        return isIncludedScript || this.queryNum < this.queries.size() - 1;
    }

    @NotNull
    private SqlJobResult getSqlJobResult() {
        if (this.queries.get(this.queries.size() - 1) == this.lastGoodQuery && this.lastError == null) {
            return SqlJobResult.SUCCESS;
        }
        if (this.lastGoodQuery != null) {
            return SqlJobResult.PARTIAL_SUCCESS;
        }
        return SqlJobResult.FAILURE;
    }

    protected void handleTransactionStatements(@NotNull DBCTransactionManager txnManager, @NotNull DBCSession session, @NotNull SQLQuery query) throws DBCException {
        if (query.getType().equals((Object)SQLQueryType.COMMIT)) {
            txnManager.commit(session);
        } else if (query.getType().equals((Object)SQLQueryType.ROLLBACK)) {
            txnManager.rollback(session, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSingleQuery(@NotNull DBCSession session, @NotNull SQLScriptElement element, boolean fireEvents) {
        block19: {
            if (!this.scriptContext.getPragmas().isEmpty() && element instanceof SQLQuery) {
                SQLQuery query = (SQLQuery)element;
                SQLQueryDataContainer container = new SQLQueryDataContainer(() -> ((SQLQueryJob)this).getExecutionContext(), query, this.scriptContext, log);
                Iterator it = this.scriptContext.getPragmas().entrySet().iterator();
                while (it.hasNext()) {
                    int result;
                    Map.Entry entry = it.next();
                    String id = (String)entry.getKey();
                    SQLPragmaHandlerDescriptor descriptor = SQLCommandsRegistry.getInstance().getPragmaHandler(id);
                    if (descriptor == null) continue;
                    try {
                        result = descriptor.createHandler().processPragma(session.getProgressMonitor(), (DBSDataContainer)container, (Map)entry.getValue());
                    }
                    catch (DBException e) {
                        this.lastError = e;
                        return false;
                    }
                    if (CommonUtils.isBitSet((int)result, (int)1)) {
                        it.remove();
                    }
                    if (!CommonUtils.isBitSet((int)result, (int)2)) continue;
                    return false;
                }
            }
            if (element instanceof SQLControlCommand) {
                SQLControlCommand controlCommand = (SQLControlCommand)element;
                try {
                    SQLControlResult controlResult;
                    SQLCommandHandlerDescriptor descriptor = SQLCommandsRegistry.getInstance().getCommandHandler(controlCommand.getCommandId());
                    if (descriptor != null && descriptor.isInteractive()) {
                        controlCommand.setData((Object)this.listener);
                    }
                    if ((controlResult = this.scriptContext.executeControlCommand(session.getProgressMonitor(), controlCommand)).getTransformed() != null) {
                        element = controlResult.getTransformed();
                        break block19;
                    }
                    if (controlResult.isSuccess()) {
                        this.lastGoodQuery = element;
                    }
                    boolean entry = controlResult.isSuccess();
                    return entry;
                }
                catch (Throwable e) {
                    if (!(e instanceof DBException)) {
                        log.error((Object)"Unexpected error while processing SQL command", e);
                    }
                    this.lastGoodQuery = element;
                    this.lastError = e;
                    boolean bl = false;
                    return bl;
                }
                finally {
                    if (element instanceof SQLControlCommand) {
                        SQLControlCommand finalCommand = (SQLControlCommand)element;
                        this.statistics.addStatementsCount();
                        this.statistics.addMessage("Command " + finalCommand.getCommand() + " processed");
                    }
                }
            }
        }
        if (!(element instanceof SQLQuery)) {
            log.error((Object)("Unsupported SQL element type: " + String.valueOf(element)));
            return false;
        }
        SQLQuery sqlQuery = (SQLQuery)element;
        List nestedElements = sqlQuery.getScriptElements();
        for (SQLScriptElement nestedElement : nestedElements) {
            if (!(nestedElement instanceof SQLQuery)) {
                log.error((Object)("Unsupported SQL element type: " + String.valueOf(element)));
                return false;
            }
            SQLQuery nestedQuery = (SQLQuery)nestedElement;
            if (this.executeSingleElement(session, fireEvents, nestedQuery)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeSingleElement(@NotNull DBCSession session, boolean fireEvents, SQLQuery sqlQuery) {
        this.lastError = null;
        if (!this.skipConfirmation && this.getDataSourceContainer().getConnectionConfiguration().getConnectionType().isConfirmExecute() && !SQLSemanticProcessor.isSelectQuery((SQLDialect)session.getDataSource().getSQLDialect(), (String)sqlQuery.getText())) {
            int confirmResult = this.confirmQueryExecution(sqlQuery, this.queries.size() > 1);
            switch (confirmResult) {
                case 3: {
                    return true;
                }
                case 2: {
                    break;
                }
                case 4: {
                    this.skipConfirmation = true;
                    break;
                }
                default: {
                    return false;
                }
            }
        }
        DBCExecutionContext executionContext = this.getExecutionContext();
        DBPDataSource dataSource = executionContext.getDataSource();
        SQLQuery originalQuery = sqlQuery;
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.beginTask("Get data receiver", 1);
        monitor.subTask("Create results view");
        if (!this.scriptContext.fillQueryParameters(originalQuery, () -> this.resultsConsumer.getDataReceiver(originalQuery, this.resultSetNumber), CommonUtils.isBitSet((long)this.fetchFlags, (long)256L))) {
            return false;
        }
        monitor.done();
        long startTime = System.currentTimeMillis();
        boolean startQueryAlerted = false;
        String queryText = originalQuery.getText();
        if (this.dataFilter != null && this.dataFilter.hasFilters()) {
            String filteredQueryText;
            try {
                filteredQueryText = dataSource.getSQLDialect().addFiltersToQuery(session.getProgressMonitor(), dataSource, queryText, this.dataFilter);
            }
            catch (DBException e) {
                log.error((Object)"Unable to add filters to query", (Throwable)e);
                this.lastError = e;
                return false;
            }
            sqlQuery = new SQLQuery(executionContext.getDataSource(), filteredQueryText, sqlQuery);
        } else {
            sqlQuery = new SQLQuery(executionContext.getDataSource(), queryText, sqlQuery);
        }
        this.curResult = new SQLQueryResult(sqlQuery);
        if (this.rsOffset > 0L) {
            this.curResult.setRowOffset(Long.valueOf(this.rsOffset));
        }
        monitor.beginTask("Process query", 1);
        monitor.subTask("Initialize context");
        try {
            this.closeStatement();
            if (!this.connectionInvalidated && dataSource.getContainer().getPreferenceStore().getBoolean("statement.invalidate.before.execute")) {
                executionContext.invalidateContext(monitor);
                this.connectionInvalidated = true;
            }
            this.statistics.setQueryText(sqlQuery.getText());
            if (fireEvents && this.listener != null) {
                try {
                    this.listener.onStartQuery(session, sqlQuery);
                }
                catch (Exception e) {
                    log.error((Object)e);
                }
                startQueryAlerted = true;
            }
            monitor.subTask("Execute query");
            startTime = System.currentTimeMillis();
            SQLQuery execStatement = sqlQuery;
            DBRRunnableParametrized executor = param -> {
                boolean changedToManualCommit = false;
                try {
                    if (this.resultsConsumer instanceof ISmartTransactionManager && ((ISmartTransactionManager)this.resultsConsumer).isSmartAutoCommit()) {
                        changedToManualCommit = DBExecUtils.checkSmartAutoCommit((DBCSession)session, (String)execStatement.getText());
                    }
                    long execStartTime = System.currentTimeMillis();
                    this.executeStatement(session, execStatement, execStartTime, this.curResult);
                }
                catch (Throwable e) {
                    if (changedToManualCommit) {
                        try {
                            DBCTransactionManager transactionManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
                            if (transactionManager != null) {
                                transactionManager.setAutoCommit(monitor, true);
                            }
                        }
                        catch (DBCException ex) {
                            log.warn((Object)"Error returning to auto commit");
                        }
                    }
                    throw new InvocationTargetException(e);
                }
            };
            if (this.shouldRecoverQuery(execStatement)) {
                DBExecUtils.tryExecuteRecover((Object)session, (DBPDataSource)session.getDataSource(), (DBRRunnableParametrized)executor);
            } else {
                try {
                    executor.run((Object)session);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            DBCTransactionManager txnManager = DBUtils.getTransactionManager((DBCExecutionContext)session.getExecutionContext());
            if (txnManager != null && txnManager.isSupportsTransactions() && !txnManager.isAutoCommit() && this.commitType != SQLScriptCommitType.AUTOCOMMIT) {
                this.handleTransactionStatements(txnManager, session, sqlQuery);
            }
        }
        catch (Throwable ex) {
            if (!(ex instanceof DBException)) {
                log.error((Object)"Unexpected error while processing SQL", ex);
            }
            this.curResult.setError(ex);
            this.lastError = ex;
        }
        finally {
            this.curResult.setQueryTime(System.currentTimeMillis() - startTime);
            if (fireEvents && this.listener != null && startQueryAlerted) {
                this.notifyQueryExecutionEnd(session, this.curResult);
            }
            monitor.done();
        }
        this.lastGoodQuery = originalQuery;
        return this.curResult.getError() == null || this.errorHandling == SQLScriptErrorHandling.IGNORE;
    }

    private boolean shouldRecoverQuery(SQLQuery query) {
        PlainSelect select;
        Statement statement = query.getStatement();
        return !(statement instanceof Insert) && !(statement instanceof Delete) && !(statement instanceof Update) && (!(statement instanceof PlainSelect) || CommonUtils.isEmpty((Collection)(select = (PlainSelect)statement).getIntoTables()));
    }

    public void notifyQueryExecutionEnd(DBCSession session, SQLQueryResult curResult) {
        try {
            this.listener.onEndQuery(session, curResult, this.statistics);
        }
        catch (Exception e) {
            log.error((Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeStatement(@NotNull DBCSession session, SQLQuery sqlQuery, long startTime, SQLQueryResult curResult) throws DBException {
        AbstractExecutionSource source = new AbstractExecutionSource(this.dataContainer, session.getExecutionContext(), (Object)this.partSite.getPart(), (Object)sqlQuery);
        source.setScriptContext((DBCScriptContext)this.scriptContext);
        DBCStatement dbcStatement = DBUtils.makeStatement((DBCExecutionSource)source, (DBCSession)session, (DBCStatementType)DBCStatementType.SCRIPT, (SQLQuery)sqlQuery, (long)this.rsOffset, (long)this.rsMaxRows);
        DBExecUtils.setStatementFetchSize((DBCStatement)dbcStatement, (long)this.rsOffset, (long)this.rsMaxRows, (int)this.fetchSize);
        this.curStatement = dbcStatement;
        int statementTimeout = this.getDataSourceContainer().getPreferenceStore().getInt("statement.timeout");
        if (statementTimeout > 0) {
            try {
                dbcStatement.setStatementTimeout(statementTimeout);
            }
            catch (Throwable e) {
                log.debug((Object)("Can't set statement timeout:" + e.getMessage()));
            }
        }
        try {
            DBRProgressMonitor monitor = session.getProgressMonitor();
            monitor.subTask("Execute query");
            boolean hasResultSet = dbcStatement.executeStatement();
            this.statistics.addExecuteTime(System.currentTimeMillis() - startTime);
            this.statistics.addStatementsCount();
            curResult.setHasResultSet(hasResultSet);
            long updateCount = -1L;
            int resultSetCounter = 0;
            int updateCountReads = 0;
            boolean confirmed = false;
            while (true) {
                DBPDataSourceInfo dataSourceInfo;
                if (this.fetchResultSetNumber < 0 || this.fetchResultSetNumber == this.resultSetNumber) {
                    if (hasResultSet && !confirmed && resultSetCounter >= this.getDataSourceContainer().getPreferenceStore().getInt("SQLEditor.resultSet.queryTabLimit")) {
                        confirmed = hasResultSet = DBWorkbench.getPlatformUI().confirmAction(SQLEditorMessages.editors_sql_warning_many_subtables_title, NLS.bind((String)SQLEditorMessages.editors_sql_warning_many_subtables_text, (Object)this.getDataSourceContainer().getPreferenceStore().getInt("SQLEditor.resultSet.queryTabLimit")), true);
                    }
                    if (hasResultSet && this.fetchResultSets) {
                        DBCResultSet resultSet;
                        try {
                            resultSet = dbcStatement.openResultSet();
                            ++resultSetCounter;
                        }
                        catch (DBCException e) {
                            DBPErrorAssistant.ErrorType errorType = DBExecUtils.discoverErrorType((DBPDataSource)session.getDataSource(), (Throwable)e);
                            if (errorType == DBPErrorAssistant.ErrorType.RESULT_SET_MISSING && dbcStatement.nextResults()) continue;
                            throw e;
                        }
                        if (resultSet == null) {
                            break;
                        }
                        DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(sqlQuery, this.resultSetNumber);
                        if (dataReceiver != null) {
                            try {
                                hasResultSet = this.fetchQueryData(session, resultSet, curResult, curResult.addExecuteResult(true), dataReceiver, true);
                            }
                            catch (DBCException e) {
                                if (this.rowsFetched == 0) {
                                    throw e;
                                }
                                log.warn((Object)"Fetch failed", (Throwable)e);
                                this.statistics.setRowsFetched((long)this.rowsFetched);
                                this.statistics.setError((Throwable)e);
                            }
                        }
                    }
                }
                if (!hasResultSet) {
                    try {
                        updateCount = dbcStatement.getUpdateRowCount();
                        SQLQueryResult.ExecuteResult executeResult = curResult.addExecuteResult(false);
                        if (updateCount >= 0L) {
                            executeResult.setUpdateCount(Long.valueOf(updateCount));
                            this.statistics.addRowsUpdated(updateCount);
                            ++updateCountReads;
                        }
                    }
                    catch (DBCException e) {
                        log.warn((Object)"Can't obtain update count", (Throwable)e);
                    }
                }
                if (hasResultSet && this.fetchResultSets) {
                    this.fetchResultSetNumber = ++this.resultSetNumber;
                }
                if (!hasResultSet) {
                    if (updateCount <= 0L && updateCountReads >= 1000) {
                        break;
                    }
                    if (updateCount < 0L) {
                        break;
                    }
                }
                if (!(dataSourceInfo = session.getDataSource().getInfo()).supportsMultipleResults()) break;
                if (this.hasLimits() && (long)this.rowsFetched >= this.rsMaxRows && dataSourceInfo.isMultipleResultsFailsOnMaxRows()) {
                    log.trace((Object)"Max rows exceeded. Additional resultsets extraction is disabled");
                    hasResultSet = false;
                } else {
                    try {
                        hasResultSet = dbcStatement.nextResults();
                    }
                    catch (DBCException e) {
                        if (dataSourceInfo.isMultipleResultsFetchBroken()) {
                            this.statistics.addWarning((Throwable)e);
                            this.statistics.setError((Throwable)e);
                            hasResultSet = dbcStatement.nextResults();
                        }
                        throw e;
                    }
                }
                updateCount = hasResultSet ? -1L : 0L;
            }
        }
        finally {
            try {
                curResult.addWarnings(dbcStatement.getStatementWarnings());
            }
            catch (Throwable e) {
                log.warn((Object)"Can't read execution warnings", e);
            }
            if (!CommonUtils.isEmpty((Collection)this.statistics.getWarnings())) {
                curResult.addWarnings(this.statistics.getWarnings().toArray(new Throwable[0]));
            }
            if (!this.keepStatementOpen()) {
                this.closeStatement();
            } else if (dbcStatement instanceof AbstractStatement) {
                AbstractStatement as = (AbstractStatement)dbcStatement;
                as.runCloseDependants();
            }
        }
    }

    private void showExecutionResult(DBCSession session) {
        if (this.isShowExecutionResult()) {
            SQLQuery query = new SQLQuery(session.getDataSource(), "", -1, -1);
            if (this.queries.size() == 1) {
                query.setText(this.queries.get(0).getText());
            }
            query.setData(STATS_RESULTS);
            DBDDataReceiver dataReceiver = this.resultsConsumer.getDataReceiver(query, this.resultSetNumber);
            if (dataReceiver != null && !(dataReceiver instanceof IDataTransferConsumer)) {
                try {
                    this.fetchExecutionResult(session, dataReceiver, query);
                }
                catch (DBException e) {
                    log.error((Object)"Error generating execution result stats", (Throwable)e);
                }
            }
        }
    }

    private boolean isShowExecutionResult() {
        DBPPreferenceStore store = this.getDataSourceContainer().getPreferenceStore();
        SQLPreferenceConstants.StatisticsTabOnExecutionBehavior statisticsTabOnExecutionBehavior = SQLPreferenceConstants.StatisticsTabOnExecutionBehavior.getByName(store.getString("SQLEditor.showStatisticsForQueriesWithResults"));
        switch (statisticsTabOnExecutionBehavior) {
            case ALWAYS: {
                return true;
            }
            case NEVER: {
                return this.resultSetNumber <= 0 || this.statistics.getRowsFetched() <= 0L;
            }
            case FOR_MULTIPLE_QUERIES: {
                if (this.resultSetNumber <= 0 || this.statistics.getRowsUpdated() >= 0L) {
                    return true;
                }
                return this.statistics.getStatementsCount() > 1;
            }
        }
        return false;
    }

    private void fetchExecutionResult(@NotNull DBCSession session, @NotNull DBDDataReceiver dataReceiver, @NotNull SQLQuery query) throws DBException {
        try (LocalStatement statStatement = new LocalStatement(session, "statistics");
             StatResultSet fakeResultSet = new StatResultSet(session, (DBCStatement)statStatement);){
            SQLQueryResult resultInfo = new SQLQueryResult(query);
            SQLQueryResult.ExecuteResult executeResult = resultInfo.addExecuteResult(true);
            if (this.statistics.getStatementsCount() > 1) {
                fakeResultSet.addColumn("Queries", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Updated Rows", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Execute time", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Fetch time", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Total time", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Start time", DBPDataKind.DATETIME);
                fakeResultSet.addColumn("Finish time", DBPDataKind.DATETIME);
                fakeResultSet.addRow(new Object[]{this.statistics.getStatementsCount(), this.statistics.getRowsUpdated() < 0L ? 0L : this.statistics.getRowsUpdated(), RuntimeUtils.formatExecutionTime((long)this.statistics.getExecuteTime()), RuntimeUtils.formatExecutionTime((long)this.statistics.getFetchTime()), RuntimeUtils.formatExecutionTime((long)this.statistics.getTotalTime()), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(this.statistics.getStartTime())), new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date())});
                executeResult.setResultSetName(SQLEditorMessages.editors_sql_statistics);
            } else {
                long updateCount = this.statistics.getRowsUpdated();
                fakeResultSet.addColumn("Updated Rows", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Execute time", DBPDataKind.NUMERIC);
                fakeResultSet.addColumn("Start time", DBPDataKind.DATETIME);
                fakeResultSet.addColumn("Finish time", DBPDataKind.DATETIME);
                fakeResultSet.addColumn("Query", DBPDataKind.STRING);
                fakeResultSet.addRow(new Object[]{updateCount, RuntimeUtils.formatExecutionTime((long)this.statistics.getExecuteTime()), new Date(this.statistics.getStartTime()), new Date(), query.getText()});
                executeResult.setResultSetName(SQLEditorMessages.editors_sql_data_grid);
            }
            this.fetchQueryData(session, (DBCResultSet)fakeResultSet, resultInfo, executeResult, dataReceiver, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean fetchQueryData(@NotNull DBCSession session, @Nullable DBCResultSet resultSet, @Nullable SQLQueryResult result, @NotNull SQLQueryResult.ExecuteResult executeResult, @NotNull DBDDataReceiver dataReceiver, boolean updateStatistics) throws DBException {
        if (resultSet == null) {
            return false;
        }
        boolean keepCursor = this.keepStatementOpen();
        if (keepCursor) {
            this.curResultSets.add(resultSet);
        }
        DBRProgressMonitor monitor = session.getProgressMonitor();
        monitor.subTask("Fetch result set");
        DBFetchProgress fetchProgress = new DBFetchProgress(session.getProgressMonitor());
        DBDDataReceiver.startFetchWorkflow((DBDDataReceiver)dataReceiver, (DBCSession)session, (DBCResultSet)resultSet, (long)this.rsOffset, (long)this.rsMaxRows);
        try {
            Object sourceName = null;
            if (result != null) {
                String queryTitle = result.getStatement().getQueryTitle();
                if (!CommonUtils.isEmpty((String)queryTitle)) {
                    sourceName = queryTitle;
                } else {
                    DBCResultSetMetaData rsMeta = resultSet.getMeta();
                    for (DBCAttributeMetaData attr : rsMeta.getAttributes()) {
                        String entityName = attr.getEntityName();
                        if (CommonUtils.isEmpty((String)entityName)) continue;
                        if (sourceName == null) {
                            sourceName = entityName;
                            continue;
                        }
                        if (((String)sourceName).equals(entityName)) continue;
                        sourceName = (String)sourceName + "(+)";
                        break;
                    }
                    if (CommonUtils.isEmpty((String)sourceName)) {
                        try {
                            sourceName = resultSet.getResultSetName();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (CommonUtils.isEmpty((String)sourceName)) {
                    sourceName = SQLEditorMessages.editors_sql_data_grid;
                }
                executeResult.setResultSetName((String)sourceName);
            }
            long fetchStartTime = System.currentTimeMillis();
            this.rowsFetched = 0;
            while (!(this.hasLimits() && fetchProgress.isMaxRowsFetched(this.rsMaxRows) || fetchProgress.isCanceled() || !resultSet.nextRow())) {
                dataReceiver.fetchRow(session, resultSet);
                ++this.rowsFetched;
                fetchProgress.monitorRowFetch();
            }
            if (updateStatistics) {
                this.statistics.addFetchTime(System.currentTimeMillis() - fetchStartTime);
            }
        }
        finally {
            if (!keepCursor) {
                try {
                    resultSet.close();
                }
                catch (Throwable e) {
                    log.error((Object)"Error while closing resultset", e);
                }
            }
        }
        if (result != null) {
            executeResult.setRowCount(Long.valueOf(fetchProgress.getRowCount()));
        }
        if (updateStatistics) {
            this.statistics.setRowsFetched(fetchProgress.getRowCount());
        }
        monitor.subTask(fetchProgress.getRowCount() + " rows fetched");
        return true;
    }

    private boolean keepStatementOpen() {
        if (!this.getExecutionContext().getDataSource().getContainer().getDriver().isThreadSafeDriver()) {
            return false;
        }
        return this.queries.size() == 1 && this.getDataSourceContainer().getPreferenceStore().getBoolean("keep.statement.open");
    }

    private void closeStatement() {
        if (this.curStatement != null) {
            try {
                for (DBCResultSet resultSet : this.curResultSets) {
                    DBUtils.closeSafely((AutoCloseable)resultSet);
                }
            }
            finally {
                this.curResultSets.clear();
                DBUtils.closeSafely((AutoCloseable)this.curStatement);
                this.curStatement = null;
            }
        }
    }

    public void extractData(@NotNull DBCSession session, @NotNull SQLScriptElement query, int resultNumber, boolean fireEvents, boolean allowStatistics) throws DBCException {
        query.reset();
        this.statistics = new DBCStatistics();
        this.resultSetNumber = resultNumber;
        session.getProgressMonitor().subTask(CommonUtils.truncateString((String)query.getText(), (int)512));
        boolean result = this.executeSingleQuery(session, query, fireEvents);
        if (this.listener != null) {
            this.listener.onEndSqlJob(session, this.getSqlJobResult());
        }
        if (!result && this.lastError != null) {
            Throwable throwable = this.lastError;
            if (throwable instanceof DBCException) {
                DBCException dbce = (DBCException)throwable;
                throw dbce;
            }
            throw new DBCException(this.lastError, this.getExecutionContext());
        }
        if (allowStatistics && result && this.statistics.getStatementsCount() > 0) {
            this.showExecutionResult(session);
        }
    }

    public void setDataFilter(DBDDataFilter dataFilter) {
        this.dataFilter = dataFilter;
    }

    public DBCStatistics getStatistics() {
        return this.statistics;
    }

    public void setFetchResultSetNumber(int fetchResultSetNumber) {
        this.fetchResultSetNumber = fetchResultSetNumber;
    }

    public boolean isJobOpen() {
        return this.curStatement != null;
    }

    public void closeJob() {
        this.closeStatement();
    }

    private int confirmQueryExecution(final @NotNull SQLQuery query, final boolean scriptMode) {
        final DBPConnectionType connectionType = this.getDataSourceContainer().getConnectionConfiguration().getConnectionType();
        return (Integer)new UITask<Integer>(this){

            protected Integer runTask() {
                MessageDialogWithToggle dialog = new MessageDialogWithToggle(UIUtils.getActiveWorkbenchShell(), "Confirm query execution", null, "You are in '" + connectionType.getName() + "' connection.\nDo you confirm query execution?", 4, ConfirmationDialog.getButtonLabels((int)6), 0, "Do not ask for " + connectionType.getName() + " connections", false){

                    protected boolean isResizable() {
                        return true;
                    }

                    protected IDialogSettings getDialogBoundsSettings() {
                        return UIUtils.getDialogSettings((String)"DBeaver.SQLQueryConfirmDialog");
                    }

                    protected void createDialogAndButtonArea(Composite parent) {
                        this.dialogArea = this.createDialogArea(parent);
                        if (this.dialogArea.getLayoutData() instanceof GridData) {
                            ((GridData)this.dialogArea.getLayoutData()).grabExcessVerticalSpace = false;
                        }
                        Text messageText = new Text(parent, 2634);
                        Object text = query.getText();
                        if (((String)text).length() > 8192) {
                            text = CommonUtils.truncateString((String)text, (int)8192) + "... (truncated " + (((String)text).length() - 8192) + " characters)";
                        }
                        messageText.setText((String)text);
                        GridData gd = new GridData(1808);
                        gd.heightHint = UIUtils.getFontHeight((Control)messageText) * 4 + 10;
                        gd.horizontalSpan = 2;
                        messageText.setLayoutData((Object)gd);
                        this.buttonBar = this.createButtonBar(parent);
                        1.applyDialogFont((Control)parent);
                    }

                    protected void createButtonsForButtonBar(Composite parent) {
                        this.createButton(parent, 2, IDialogConstants.YES_LABEL, true);
                        this.createButton(parent, 3, IDialogConstants.NO_LABEL, false);
                        if (scriptMode) {
                            this.createButton(parent, 4, IDialogConstants.YES_TO_ALL_LABEL, false);
                            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                        }
                    }
                };
                int result = dialog.open();
                if (dialog.getToggleState()) {
                    connectionType.setConfirmExecute(false);
                    DBWorkbench.getPlatform().getDataSourceProviderRegistry().saveConnectionTypes();
                }
                return result;
            }
        }.execute();
    }
}

