/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.team.git.ui.handlers;

import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IResource;
import org.eclipse.egit.ui.internal.history.HistoryPageInput;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.ui.history.IHistoryView;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.team.git.ui.handlers.GITAbstractHandler;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.utils.ArrayUtils;

public class GITHistoryHandler
extends GITAbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Object[] repos = this.getRepositories(event);
        if (ArrayUtils.isEmpty((Object[])repos)) {
            Object[] selectedResources = this.getSelectedResources(event);
            if (ArrayUtils.isEmpty((Object[])selectedResources)) {
                UIUtils.showMessageBox((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"No repository", (String)"You need to select a resource to view Git history", (int)8);
            } else {
                String resourceNames = Arrays.stream(selectedResources).map(r -> r.getFullPath().toString()).collect(Collectors.joining(","));
                UIUtils.showMessageBox((Shell)HandlerUtil.getActiveShell((ExecutionEvent)event), (String)"No repository", (String)("No Git repository associated with selected resource(s):\n" + resourceNames), (int)8);
            }
            return null;
        }
        try {
            IWorkbenchPage page;
            IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            if (activeWorkbenchWindow != null && (page = activeWorkbenchWindow.getActivePage()) != null) {
                IResource[] resources = this.getSelectedResources(event);
                IHistoryView view = (IHistoryView)page.showView("org.eclipse.team.ui.GenericHistoryView");
                if (resources.length == 1) {
                    view.showHistoryFor((Object)resources[0]);
                    return null;
                }
                HistoryPageInput list = new HistoryPageInput((Repository)repos[0], resources);
                view.showHistoryFor((Object)list);
            }
            return null;
        }
        catch (PartInitException var8) {
            throw new ExecutionException(var8.getMessage(), (Throwable)var8);
        }
    }
}

