/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.team.git.ui.handlers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.operations.GitScopeUtil;
import org.eclipse.egit.ui.internal.selection.SelectionUtils;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.navigator.DBNRoot;
import org.jkiss.dbeaver.model.rcp.RCPProject;
import org.jkiss.dbeaver.ui.editors.EditorUtils;
import org.jkiss.dbeaver.ui.navigator.INavigatorModelView;
import org.jkiss.dbeaver.utils.GeneralUtils;

public abstract class GITAbstractHandler
extends AbstractHandler {
    private static final Log log = Log.getLog(GITAbstractHandler.class);

    protected IResource[] getResourcesInScope(ExecutionEvent event) throws ExecutionException {
        try {
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            if (activePart instanceof IEditorPart) {
                IFile editorFile = EditorUtils.getFileFromInput((IEditorInput)((IEditorPart)activePart).getEditorInput());
                if (editorFile != null) {
                    return new IResource[]{editorFile};
                }
                return new IResource[0];
            }
            IResource[] selectedResources = this.getSelectedResources(event);
            if (selectedResources.length > 0) {
                IWorkbenchPart part = HandlerUtil.getActivePart((ExecutionEvent)event);
                return GitScopeUtil.getRelatedChanges((IWorkbenchPart)part, (IResource[])selectedResources);
            }
            return new IResource[0];
        }
        catch (Exception e) {
            log.error((Object)e);
            return null;
        }
    }

    protected Repository getRepository(boolean warn, ExecutionEvent event) {
        Shell shell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof IEditorPart) {
            IFile editorFile = EditorUtils.getFileFromInput((IEditorInput)((IEditorPart)activePart).getEditorInput());
            if (editorFile != null) {
                return SelectionUtils.getRepositoryOrWarn((IStructuredSelection)new StructuredSelection((Object)editorFile), (Shell)shell);
            }
            return null;
        }
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        if (warn) {
            return SelectionUtils.getRepositoryOrWarn((IStructuredSelection)selection, (Shell)shell);
        }
        return SelectionUtils.getRepository((IStructuredSelection)selection);
    }

    protected IResource[] getSelectedResources(ExecutionEvent event) {
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        return SelectionUtils.getSelectedResources((IStructuredSelection)selection);
    }

    protected Repository[] getRepositories(ExecutionEvent event) {
        DBPProject ownerProject;
        DBNNode rootNode;
        Repository repository;
        IFile editorFile;
        IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
        if (activePart instanceof IEditorPart && (editorFile = EditorUtils.getFileFromInput((IEditorInput)((IEditorPart)activePart).getEditorInput())) != null && (repository = SelectionUtils.getRepository((IStructuredSelection)new StructuredSelection((Object)editorFile))) != null) {
            return new Repository[]{repository};
        }
        INavigatorModelView navigatorModelView = (INavigatorModelView)GeneralUtils.adapt((Object)activePart, INavigatorModelView.class);
        if (navigatorModelView != null && !((rootNode = navigatorModelView.getRootNode()) instanceof DBNRoot) && rootNode != null && (ownerProject = rootNode.getOwnerProject()) instanceof RCPProject) {
            RCPProject rcpProject = (RCPProject)ownerProject;
            return GITAbstractHandler.getRepositories((IStructuredSelection)new StructuredSelection((Object)rcpProject.getEclipseProject()));
        }
        IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
        return GITAbstractHandler.getRepositories(selection);
    }

    private static Repository[] getRepositories(IStructuredSelection selection) {
        IProject[] selectedProjects = GITAbstractHandler.getSelectedProjects(selection);
        if (selectedProjects.length > 0) {
            return GITAbstractHandler.getRepositoriesFor(selectedProjects);
        }
        if (selection.isEmpty()) {
            return new Repository[0];
        }
        LinkedHashSet<Repository> repos = new LinkedHashSet<Repository>();
        for (Object o : selection.toArray()) {
            Repository repo = (Repository)Adapters.adapt((Object)o, Repository.class);
            if (repo == null) {
                return new Repository[0];
            }
            repos.add(repo);
        }
        return repos.toArray(new Repository[0]);
    }

    private static IProject[] getSelectedProjects(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        for (IResource resource : GITAbstractHandler.getSelectedAdaptables((ISelection)selection, IResource.class)) {
            RepositoryMapping mapping = RepositoryMapping.getMapping((IResource)resource);
            if (mapping != null && mapping.getContainer() instanceof IProject) {
                ret.add((IProject)mapping.getContainer());
                continue;
            }
            return new IProject[0];
        }
        ret.addAll(GITAbstractHandler.extractProjectsFromMappings(selection));
        return ret.toArray(new IProject[0]);
    }

    private static <T> List<T> getSelectedAdaptables(ISelection selection, Class<T> c) {
        List result;
        if (selection != null && !selection.isEmpty()) {
            result = new ArrayList();
            Iterator elements = ((IStructuredSelection)selection).iterator();
            while (elements.hasNext()) {
                Object adapter = Adapters.adapt(elements.next(), c);
                if (adapter == null) continue;
                result.add(adapter);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    private static Set<IProject> extractProjectsFromMappings(IStructuredSelection selection) {
        LinkedHashSet<IProject> ret = new LinkedHashSet<IProject>();
        for (ResourceMapping mapping : GITAbstractHandler.getSelectedAdaptables((ISelection)selection, ResourceMapping.class)) {
            IProject[] mappedProjects = mapping.getProjects();
            if (mappedProjects == null || mappedProjects.length == 0) continue;
            ArrayList<IProject> projects = new ArrayList<IProject>(Arrays.asList(mappedProjects));
            projects.sort(CommonUtils.RESOURCE_NAME_COMPARATOR);
            ret.addAll(projects);
        }
        return ret;
    }

    private static Repository[] getRepositoriesFor(IProject[] projects) {
        LinkedHashSet<Repository> ret = new LinkedHashSet<Repository>();
        for (IProject project : projects) {
            RepositoryMapping repositoryMapping = RepositoryMapping.getMapping((IProject)project);
            if (repositoryMapping == null) {
                return new Repository[0];
            }
            ret.add(repositoryMapping.getRepository());
        }
        return ret.toArray(new Repository[0]);
    }
}

