/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.ai.registry;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.ai.AIFunction;
import org.jkiss.dbeaver.model.ai.AIFunctionContext;
import org.jkiss.dbeaver.model.ai.AIFunctionPurpose;
import org.jkiss.dbeaver.model.ai.AIFunctionResult;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionCategoryDescriptor;
import org.jkiss.dbeaver.model.ai.registry.AIFunctionDescriptor;

public class AIFunctionRegistry {
    private static final Log log = Log.getLog(AIFunctionRegistry.class);
    private static AIFunctionRegistry instance;
    private final Map<String, AIFunctionDescriptor> functionsById = new LinkedHashMap<String, AIFunctionDescriptor>();
    private final Map<String, AIFunctionCategoryDescriptor> categoriesById = new LinkedHashMap<String, AIFunctionCategoryDescriptor>();

    public static synchronized AIFunctionRegistry getInstance() {
        if (instance == null) {
            instance = new AIFunctionRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    public AIFunctionRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        for (IConfigurationElement el : extElements = registry.getConfigurationElementsFor("com.dbeaver.ai.function")) {
            if (!"category".equals(el.getName())) continue;
            AIFunctionCategoryDescriptor cd = new AIFunctionCategoryDescriptor(el);
            this.categoriesById.put(cd.getId(), cd);
        }
        for (IConfigurationElement ext : extElements) {
            if (!"function".equals(ext.getName())) continue;
            AIFunctionDescriptor fd = new AIFunctionDescriptor(ext);
            this.functionsById.put(fd.getId(), fd);
        }
    }

    @Nullable
    public AIFunctionDescriptor getFunction(@NotNull String id) {
        return this.functionsById.get(id);
    }

    @NotNull
    public List<AIFunctionDescriptor> getAllFunctions(@NotNull AIFunctionPurpose purpose) {
        return this.functionsById.values().stream().filter(f -> f.getPurpose() == AIFunctionPurpose.ALL || purpose == AIFunctionPurpose.ALL || f.getPurpose() == purpose).toList();
    }

    @NotNull
    public List<AIFunctionCategoryDescriptor> getAllCategories() {
        return new ArrayList<AIFunctionCategoryDescriptor>(this.categoriesById.values());
    }

    @NotNull
    public Map<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>> getFunctionsByCategory() {
        LinkedHashMap<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>> map = new LinkedHashMap<AIFunctionCategoryDescriptor, List<AIFunctionDescriptor>>();
        for (AIFunctionCategoryDescriptor cat : this.categoriesById.values()) {
            map.put(cat, new ArrayList());
        }
        for (AIFunctionDescriptor f : this.functionsById.values()) {
            AIFunctionCategoryDescriptor cat = this.categoriesById.get(f.getCategoryId());
            if (cat == null) continue;
            ((List)map.get((Object)cat)).add(f);
        }
        return map;
    }

    @NotNull
    public Set<String> getDefaultEnabledCategoryIds() {
        LinkedHashSet<String> ids = new LinkedHashSet<String>();
        for (AIFunctionCategoryDescriptor c : this.categoriesById.values()) {
            if (!c.isEnabledByDefault()) continue;
            ids.add(c.getId());
        }
        return ids;
    }

    @NotNull
    public AIFunctionResult callFunction(@NotNull AIFunctionContext context, @NotNull AIFunctionDescriptor descriptor, @NotNull Map<String, Object> arguments) throws DBException {
        AIFunction function = descriptor.createInstance();
        return function.callFunction(context, arguments);
    }
}

