/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.postgresql.debug.ui.internal;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.debug.ui.DBGConfigurationPanel;
import org.jkiss.dbeaver.debug.ui.DBGConfigurationPanelContainer;
import org.jkiss.dbeaver.ext.postgresql.debug.core.PostgreSqlDebugCore;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedure;
import org.jkiss.dbeaver.ext.postgresql.model.PostgreProcedureParameter;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSObjectContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSProcedureParameter;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.controls.CSmartCombo;
import org.jkiss.dbeaver.ui.controls.CSmartSelector;
import org.jkiss.dbeaver.ui.controls.CustomTableEditor;
import org.jkiss.utils.CommonUtils;

public class PostgreDebugPanelFunction
implements DBGConfigurationPanel {
    private static final int PARAMETERS_TABLE_MAX_HEIGHT = 150;
    private DBGConfigurationPanelContainer container;
    private Button kindLocal;
    private Button kindGlobal;
    private CSmartCombo<PostgreProcedure> functionCombo;
    private Text processIdText;
    private PostgreProcedure selectedFunction;
    private Map<DBSProcedureParameter, Object> parameterValues = new HashMap<DBSProcedureParameter, Object>();
    private Table parametersTable;

    public void createPanel(@NotNull Composite parent, final DBGConfigurationPanelContainer container) {
        this.container = container;
        Composite kindGroup = UIUtils.createTitledComposite((Composite)parent, (String)"Attach type", (int)2, (int)32);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PostgreDebugPanelFunction.this.processIdText.setEnabled(PostgreDebugPanelFunction.this.kindGlobal.getSelection());
                PostgreDebugPanelFunction.this.parametersTable.setEnabled(PostgreDebugPanelFunction.this.kindLocal.getSelection());
                container.updateDialogState();
            }
        };
        this.kindLocal = new Button(kindGroup, 16);
        this.kindLocal.setText("Local");
        this.kindLocal.addSelectionListener((SelectionListener)listener);
        this.kindGlobal = new Button(kindGroup, 16);
        this.kindGlobal.setText("Global");
        this.kindGlobal.addSelectionListener((SelectionListener)listener);
        this.kindGlobal.setEnabled(false);
        this.createFunctionGroup(parent);
        this.createParametersGroup(parent);
    }

    private void createFunctionGroup(final Composite parent) {
        Composite functionGroup = UIUtils.createTitledComposite((Composite)parent, (String)"Function", (int)2, (int)2);
        UIUtils.createControlLabel((Composite)functionGroup, (String)"Function");
        this.functionCombo = new CSmartSelector<PostgreProcedure>(functionGroup, 2060, (ILabelProvider)new LabelProvider(this){

            public Image getImage(Object element) {
                return DBeaverIcons.getImage((DBPImage)DBIcon.TREE_PROCEDURE);
            }

            public String getText(Object element) {
                if (element == null) {
                    return "N/A";
                }
                return ((PostgreProcedure)element).getFullQualifiedSignature();
            }
        }){

            protected void dropDown(boolean drop) {
                DBNModel navigatorModel;
                DBNDatabaseNode dsNode;
                if (drop && (dsNode = (navigatorModel = DBWorkbench.getPlatform().getNavigatorModel()).getNodeByObject((DBSObject)PostgreDebugPanelFunction.this.container.getDataSource())) != null) {
                    DBNDatabaseNode curNode = PostgreDebugPanelFunction.this.selectedFunction == null ? null : navigatorModel.getNodeByObject((DBSObject)PostgreDebugPanelFunction.this.selectedFunction);
                    DBNNode node = DBWorkbench.getPlatformUI().selectObject((Object)parent.getShell(), "Select function to debug", (DBNNode)dsNode, (DBNNode)curNode, new Class[]{DBSInstance.class, DBSObjectContainer.class, PostgreProcedure.class}, new Class[]{PostgreProcedure.class}, null);
                    if (node instanceof DBNDatabaseNode && ((DBNDatabaseNode)node).getObject() instanceof PostgreProcedure) {
                        PostgreDebugPanelFunction.this.functionCombo.removeAll();
                        PostgreDebugPanelFunction.this.selectedFunction = (PostgreProcedure)((DBNDatabaseNode)node).getObject();
                        PostgreDebugPanelFunction.this.functionCombo.addItem((Object)PostgreDebugPanelFunction.this.selectedFunction);
                        PostgreDebugPanelFunction.this.functionCombo.select((Object)PostgreDebugPanelFunction.this.selectedFunction);
                        PostgreDebugPanelFunction.this.updateParametersTable();
                        PostgreDebugPanelFunction.this.container.updateDialogState();
                    }
                    PostgreDebugPanelFunction.this.parametersTable.setEnabled(PostgreDebugPanelFunction.this.selectedFunction != null);
                }
            }
        };
        this.functionCombo.addItem(null);
        GridData gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight(this.functionCombo) * 40 + 10;
        this.functionCombo.setLayoutData((Object)gd);
        this.processIdText = UIUtils.createLabelText((Composite)functionGroup, (String)"Process ID", (String)"", (int)2048, (Object)new GridData(32));
        gd = new GridData(32);
        gd.widthHint = UIUtils.getFontHeight((Control)this.processIdText) * 10 + 10;
        this.processIdText.setLayoutData((Object)gd);
    }

    private void createParametersGroup(Composite parent) {
        Composite composite = UIUtils.createTitledComposite((Composite)parent, (String)"Function parameters", (int)2, (int)1808);
        this.parametersTable = new Table(composite, 68356);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumHeight = 150;
        this.parametersTable.setLayoutData((Object)gd);
        this.parametersTable.setHeaderVisible(true);
        this.parametersTable.setLinesVisible(true);
        this.parametersTable.addListener(11, new Listener(){

            public void handleEvent(Event arg0) {
                Point size = PostgreDebugPanelFunction.this.parametersTable.getSize();
                if (size.y > 150) {
                    PostgreDebugPanelFunction.this.parametersTable.setSize(size.x, 150);
                }
            }
        });
        TableColumn nameColumn = UIUtils.createTableColumn((Table)this.parametersTable, (int)16384, (String)"Name");
        nameColumn.setWidth(100);
        TableColumn valueColumn = UIUtils.createTableColumn((Table)this.parametersTable, (int)16384, (String)"Value");
        valueColumn.setWidth(200);
        TableColumn typeColumn = UIUtils.createTableColumn((Table)this.parametersTable, (int)16384, (String)"Type");
        typeColumn.setWidth(60);
        TableColumn kindColumn = UIUtils.createTableColumn((Table)this.parametersTable, (int)16384, (String)"Kind");
        kindColumn.setWidth(40);
        new CustomTableEditor(this.parametersTable){
            {
                this.firstTraverseIndex = 1;
                this.lastTraverseIndex = 1;
                this.editOnEnter = false;
            }

            protected Control createEditor(Table table, int index, TableItem item) {
                if (index != 1) {
                    return null;
                }
                DBSProcedureParameter param = (DBSProcedureParameter)item.getData();
                Text editor = new Text((Composite)table, 2048);
                editor.setText(CommonUtils.toString((Object)PostgreDebugPanelFunction.this.parameterValues.get(param), (String)""));
                editor.selectAll();
                return editor;
            }

            protected void saveEditorValue(Control control, int index, TableItem item) {
                DBSProcedureParameter param = (DBSProcedureParameter)item.getData();
                String newValue = ((Text)control).getText();
                item.setText(1, newValue);
                PostgreDebugPanelFunction.this.parameterValues.put(param, newValue);
                PostgreDebugPanelFunction.this.container.updateDialogState();
            }
        };
    }

    public void loadConfiguration(DBPDataSourceContainer dataSource, Map<String, Object> configuration) {
        Object kind = configuration.get("PG.ATTR_ATTACH_KIND");
        boolean isGlobal = "GLOBAL".equals(kind);
        this.kindGlobal.setSelection(isGlobal);
        this.kindLocal.setSelection(!isGlobal);
        Object processId = configuration.get("PG.ATTACH_PROCESS");
        this.processIdText.setText(processId == null ? "" : processId.toString());
        long functionId = CommonUtils.toLong((Object)configuration.get("PG.ATTR_FUNCTION_OID"));
        if (functionId != 0L && dataSource != null) {
            try {
                this.container.getRunnableContext().run(true, true, monitor -> {
                    try {
                        this.selectedFunction = PostgreSqlDebugCore.resolveFunction((DBRProgressMonitor)monitor, (DBPDataSourceContainer)dataSource, (Map)configuration);
                    }
                    catch (DBException e) {
                        throw new InvocationTargetException(e);
                    }
                });
                this.container.setWarningMessage(null);
            }
            catch (InvocationTargetException e) {
                this.container.setWarningMessage(e.getTargetException().getMessage());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        if (this.selectedFunction != null) {
            List parameters;
            List paramValues = (List)configuration.get("PG.ATTR_FUNCTION_PARAMETERS");
            if (paramValues != null && (parameters = this.selectedFunction.getInputParameters()).size() == paramValues.size()) {
                for (int i = 0; i < parameters.size(); ++i) {
                    PostgreProcedureParameter param = (PostgreProcedureParameter)parameters.get(i);
                    this.parameterValues.put((DBSProcedureParameter)param, paramValues.get(i));
                }
            }
            this.updateParametersTable();
        }
        this.parametersTable.setEnabled(this.selectedFunction != null && !isGlobal);
        this.processIdText.setEnabled(isGlobal);
        if (this.selectedFunction != null) {
            this.functionCombo.addItem((Object)this.selectedFunction);
            this.functionCombo.select((Object)this.selectedFunction);
        }
    }

    private void updateParametersTable() {
        this.parametersTable.removeAll();
        for (DBSProcedureParameter param : this.selectedFunction.getInputParameters()) {
            TableItem item = new TableItem(this.parametersTable, 0);
            item.setData((Object)param);
            item.setImage(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_ATTRIBUTE));
            item.setText(0, param.getName());
            Object value = this.parameterValues.get(param);
            item.setText(1, CommonUtils.toString((Object)value, (String)""));
            item.setText(2, param.getParameterType().getFullTypeName());
            item.setText(3, param.getParameterKind().getTitle());
        }
        this.parametersTable.select(0);
    }

    public void saveConfiguration(DBPDataSourceContainer dataSource, Map<String, Object> configuration) {
        configuration.put("PG.ATTR_ATTACH_KIND", this.kindGlobal.getSelection() ? "GLOBAL" : "LOCAL");
        configuration.put("PG.ATTACH_PROCESS", this.processIdText.getText());
        if (this.selectedFunction != null) {
            configuration.put("PG.ATTR_FUNCTION_OID", this.selectedFunction.getObjectId());
            configuration.put("PG.ATTR_DATABASE_NAME", this.selectedFunction.getDatabase().getName());
            configuration.put("PG.ATTR_SCHEMA_NAME", this.selectedFunction.getSchema().getName());
            ArrayList<String> paramValues = new ArrayList<String>();
            for (PostgreProcedureParameter param : this.selectedFunction.getInputParameters()) {
                Object value = this.parameterValues.get(param);
                paramValues.add(value == null ? null : value.toString());
            }
            configuration.put("PG.ATTR_FUNCTION_PARAMETERS", paramValues);
        } else {
            configuration.remove("PG.ATTR_FUNCTION_OID");
            configuration.remove("PG.ATTR_DATABASE_NAME");
            configuration.remove("PG.ATTR_SCHEMA_NAME");
            configuration.remove("PG.ATTR_FUNCTION_PARAMETERS");
        }
    }

    public boolean isValid() {
        return this.selectedFunction != null;
    }
}

