/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ext.altibase.data;

import java.sql.SQLException;
import java.util.BitSet;
import org.jkiss.dbeaver.model.exec.DBCException;
import org.jkiss.dbeaver.model.exec.DBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCPreparedStatement;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCResultSet;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.impl.jdbc.data.handlers.JDBCObjectValueHandler;
import org.jkiss.dbeaver.model.struct.DBSTypedObject;

public class AltibaseBitSetValueHandler
extends JDBCObjectValueHandler {
    public static final AltibaseBitSetValueHandler INSTANCE = new AltibaseBitSetValueHandler();

    protected Object fetchColumnValue(DBCSession session, JDBCResultSet resultSet, DBSTypedObject type, int index) throws DBCException, SQLException {
        String value = null;
        Object obj = resultSet.getObject(index);
        if (obj != null && !resultSet.wasNull()) {
            BitSet bitSet = (BitSet)obj;
            int size = bitSet.size();
            StringBuilder sb = new StringBuilder(size);
            for (int i = 0; i < size; ++i) {
                sb.append(bitSet.get(i) ? (char)'1' : '0');
            }
            value = sb.toString();
        }
        return this.getValueFromObject(session, type, value, false, false);
    }

    protected void bindParameter(JDBCSession session, JDBCPreparedStatement statement, DBSTypedObject paramType, int paramIndex, Object value) throws DBCException, SQLException {
        if (value == null) {
            statement.setNull(paramIndex, paramType.getTypeID());
        } else {
            try {
                statement.setObject(paramIndex, (Object)value.toString(), -7);
            }
            catch (SQLException e) {
                statement.setObject(paramIndex, value);
            }
        }
    }
}

