/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.ui;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.ILaunchShortcut2;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.ui.DebugUI;
import org.jkiss.dbeaver.debug.ui.internal.DebugUIMessages;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.runtime.DBWorkbench;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.utils.CommonUtils;

public abstract class DatabaseLaunchShortcut
implements ILaunchShortcut2 {
    private static final Log log = Log.getLog(DatabaseLaunchShortcut.class);
    private final String configurationTypeId;
    private final String launchObjectName;
    private IWorkbenchPartSite workbenchPartSite;

    public DatabaseLaunchShortcut(String typeId, String objectName) {
        this.configurationTypeId = typeId;
        this.launchObjectName = objectName;
    }

    public void launch(ISelection selection, String mode) {
        if (selection instanceof IStructuredSelection) {
            IWorkbenchPart activePart;
            IWorkbenchPage activePage;
            IWorkbenchWindow activeWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null && (activePart = activePage.getActivePart()) != null) {
                this.workbenchPartSite = activePart.getSite();
            }
            Object[] array = ((IStructuredSelection)selection).toArray();
            this.searchAndLaunch(array, mode, this.getSelectionEmptyMessage());
        }
    }

    public void launch(IEditorPart editor, String mode) {
        IEditorSite editorSite = editor.getEditorSite();
        this.workbenchPartSite = editorSite;
        ISelection selection = editorSite.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            Object[] array = ((IStructuredSelection)selection).toArray();
            this.searchAndLaunch(array, mode, this.getEditorEmptyMessage());
        } else {
            DBSObject databaseObject = DebugUI.extractDatabaseObject(editor);
            if (databaseObject != null) {
                Object[] array = new Object[]{databaseObject};
                this.searchAndLaunch(array, mode, this.getEditorEmptyMessage());
            }
        }
    }

    protected IWorkbenchPartSite getWorkbenchPartSite() {
        return this.workbenchPartSite;
    }

    protected String getSelectionEmptyMessage() {
        String message = DebugUIMessages.DatabaseLaunchShortcut_e_selection_empty;
        return NLS.bind((String)message, (Object)this.launchObjectName);
    }

    protected String getEditorEmptyMessage() {
        String message = DebugUIMessages.DatabaseLaunchShortcut_e_editor_empty;
        return NLS.bind((String)message, (Object)this.launchObjectName);
    }

    protected String getLaunchableSelectionTitle(String mode) {
        String message = DebugUIMessages.DatabaseLaunchShortcut_select_title;
        return NLS.bind((String)message, (Object)this.launchObjectName);
    }

    protected String getLaunchableSelectionMessage(String mode) {
        String message = DebugUIMessages.DatabaseLaunchShortcut_select_message;
        return NLS.bind((String)message, (Object)this.launchObjectName);
    }

    protected ILabelProvider getLaunchableSelectionRenderer() {
        return WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider();
    }

    protected Shell getShell() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    protected void searchAndLaunch(Object[] scope, String mode, String emptyMessage) {
        List extracted = DebugUtils.extractLaunchable((Object[])scope);
        DBSObject launchable = null;
        if (extracted.size() == 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)DebugUIMessages.DatabaseLaunchShortcut_e_launch, (String)emptyMessage);
        } else {
            launchable = extracted.size() > 1 ? this.selectLaunchable(this.getShell(), extracted, mode) : (DBSObject)extracted.get(0);
        }
        if (launchable != null) {
            try {
                this.launch(launchable, mode);
            }
            catch (CoreException e) {
                DBWorkbench.getPlatformUI().showError(DebugUIMessages.DatabaseLaunchShortcut_e_launch, "Cannot launch debug", e.getStatus());
            }
        }
    }

    protected void launch(DBSObject launchable, String mode) throws CoreException {
        Map databaseContext = DebugUtils.resolveDatabaseContext((DBSObject)launchable);
        List<ILaunchConfiguration> configs = this.getCandidates(launchable, this.getConfigurationType(), databaseContext);
        if (configs != null) {
            ILaunchConfiguration config = null;
            int count = configs.size();
            if (count == 1) {
                config = configs.get(0);
            } else if (count > 1 && (config = this.chooseConfiguration(configs, mode)) == null) {
                return;
            }
            if (config == null) {
                config = this.createConfiguration(launchable, databaseContext);
                if (DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)UIUtils.getActiveWorkbenchShell(), (ILaunchConfiguration)config, (String)"org.jkiss.dbeaver.debug.launchGroup") != 0) {
                    return;
                }
                if (config instanceof ILaunchConfigurationWorkingCopy) {
                    ((ILaunchConfigurationWorkingCopy)config).doSave();
                }
            }
            if (config != null) {
                DebugUITools.launch((ILaunchConfiguration)config, (String)mode);
            }
        }
    }

    protected ILaunchConfigurationType getConfigurationType() {
        ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
        String configurationTypeId = this.getConfigurationTypeId();
        return lm.getLaunchConfigurationType(configurationTypeId);
    }

    protected String getConfigurationTypeId() {
        return this.configurationTypeId;
    }

    protected String getLaunchObjectName() {
        return this.launchObjectName;
    }

    protected DBSObject selectLaunchable(Shell shell, List<DBSObject> launchables, String mode) {
        String title = this.getLaunchableSelectionTitle(mode);
        String message = this.getLaunchableSelectionMessage(mode);
        ILabelProvider renderer = this.getLaunchableSelectionRenderer();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(shell, renderer);
        dialog.setTitle(title);
        dialog.setMessage(message);
        dialog.setElements(launchables.toArray());
        dialog.setMultipleSelection(false);
        if (dialog.open() != 0) {
            return null;
        }
        return (DBSObject)dialog.getFirstResult();
    }

    protected List<ILaunchConfiguration> getCandidates(DBSObject launchable, ILaunchConfigurationType configType, Map<String, Object> databaseContext) throws CoreException {
        ILaunchConfiguration[] configs;
        ArrayList<ILaunchConfiguration> candidateConfigs = new ArrayList<ILaunchConfiguration>();
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunchConfiguration[] iLaunchConfigurationArray = configs = launchManager.getLaunchConfigurations(configType);
        int n = configs.length;
        int n2 = 0;
        while (n2 < n) {
            ILaunchConfiguration config = iLaunchConfigurationArray[n2];
            if (this.isCandidate(config, launchable, databaseContext)) {
                candidateConfigs.add(config);
            }
            ++n2;
        }
        return candidateConfigs;
    }

    protected boolean isCandidate(ILaunchConfiguration config, DBSObject launchable, Map<String, Object> databaseContext) throws CoreException {
        if (!config.exists()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : databaseContext.entrySet()) {
            if (CommonUtils.equalObjects((Object)config.getAttribute(entry.getKey(), null), (Object)entry.getValue())) continue;
            return false;
        }
        return true;
    }

    protected ILaunchConfiguration chooseConfiguration(List<ILaunchConfiguration> configList, String mode) {
        IDebugModelPresentation labelProvider = DebugUITools.newDebugModelPresentation();
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.getShell(), (ILabelProvider)labelProvider);
        dialog.setElements(configList.toArray());
        dialog.setTitle(DebugUIMessages.DatabaseLaunchShortcut_select_configuration_title);
        dialog.setMessage(DebugUIMessages.DatabaseLaunchShortcut_select_configuration_message);
        dialog.setMultipleSelection(false);
        int result = dialog.open();
        labelProvider.dispose();
        if (result == 0) {
            return (ILaunchConfiguration)dialog.getFirstResult();
        }
        return null;
    }

    protected abstract ILaunchConfiguration createConfiguration(DBSObject var1, Map<String, Object> var2) throws CoreException;

    public ILaunchConfiguration[] getLaunchConfigurations(ISelection selection) {
        return null;
    }

    public ILaunchConfiguration[] getLaunchConfigurations(IEditorPart editorpart) {
        return null;
    }

    public IResource getLaunchableResource(ISelection selection) {
        Object element;
        IStructuredSelection ss;
        if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (element = ss.getFirstElement()) instanceof IAdaptable) {
            return this.getLaunchableResource((IAdaptable)element);
        }
        return null;
    }

    public IResource getLaunchableResource(IEditorPart editorpart) {
        return this.getLaunchableResource((IAdaptable)editorpart.getEditorInput());
    }

    protected IResource getLaunchableResource(IAdaptable adaptable) {
        return (IResource)GeneralUtils.adapt((Object)adaptable, IResource.class);
    }
}

