/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.jdbc;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.DBGBaseController;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.dbeaver.debug.DBGEvent;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.debug.DBGSession;
import org.jkiss.dbeaver.debug.jdbc.DBGJDBCWorker;
import org.jkiss.dbeaver.model.exec.DBCExecutionPurpose;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCSession;
import org.jkiss.dbeaver.model.exec.jdbc.JDBCStatement;
import org.jkiss.dbeaver.model.impl.jdbc.JDBCExecutionContext;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class DBGJDBCSession
implements DBGSession {
    private static final Log log = Log.getLog(DBGJDBCSession.class);
    private final DBGBaseController controller;
    protected volatile DBGJDBCWorker workerJob;
    private final List<DBGBreakpointDescriptor> breakpoints = new ArrayList<DBGBreakpointDescriptor>(1);

    protected DBGJDBCSession(DBGBaseController controller) {
        this.controller = controller;
    }

    protected DBGBaseController getController() {
        return this.controller;
    }

    public abstract JDBCExecutionContext getControllerConnection();

    public abstract boolean isAttached();

    public boolean isWaiting() {
        DBGJDBCWorker job = this.workerJob;
        return job != null && !job.isFinished();
    }

    public abstract boolean isDone();

    protected void runAsync(String commandSQL, String name, DBGEvent begin, DBGEvent end) throws DBGException {
        this.workerJob = new DBGJDBCWorker(this, name, commandSQL, begin, end);
        this.workerJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                DBGJDBCSession.this.workerJob = null;
            }
        });
        this.workerJob.schedule();
    }

    @Override
    public void closeSession(DBRProgressMonitor monitor) throws DBGException {
        if (!this.isAttached()) {
            return;
        }
        this.doDetach(monitor);
        if (!this.isDone() && this.workerJob != null) {
            this.workerJob.cancel();
            this.workerJob = null;
        }
    }

    protected abstract void doDetach(DBRProgressMonitor var1) throws DBGException;

    protected abstract String composeAbortCommand();

    @Override
    public List<? extends DBGBreakpointDescriptor> getBreakpoints() {
        return new ArrayList<DBGBreakpointDescriptor>(this.breakpoints);
    }

    @Override
    public void addBreakpoint(DBRProgressMonitor monitor, DBGBreakpointDescriptor descriptor) throws DBGException {
        try (JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Add breakpoint");){
            try (JDBCStatement stmt = session.createStatement();){
                String sqlQuery = this.composeAddBreakpointCommand(descriptor);
                stmt.execute(sqlQuery);
            }
            catch (SQLException e) {
                throw new DBGException("SQL error", e);
            }
            this.breakpoints.add(descriptor);
        }
    }

    protected abstract String composeAddBreakpointCommand(DBGBreakpointDescriptor var1);

    @Override
    public void removeBreakpoint(DBRProgressMonitor monitor, DBGBreakpointDescriptor bp) throws DBGException {
        try (JDBCSession session = this.getControllerConnection().openSession(monitor, DBCExecutionPurpose.UTIL, "Remove breakpoint");){
            try (JDBCStatement stmt = session.createStatement();){
                String sqlCommand = this.composeRemoveBreakpointCommand(bp);
                stmt.execute(sqlCommand);
            }
            catch (SQLException e) {
                throw new DBGException("SQL error", e);
            }
            this.breakpoints.remove(bp);
        }
    }

    protected abstract String composeRemoveBreakpointCommand(DBGBreakpointDescriptor var1);

    protected void fireEvent(DBGEvent event) {
        this.controller.fireEvent(event);
    }
}

