/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug.core.model;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.osgi.util.NLS;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.DBGBreakpointDescriptor;
import org.jkiss.dbeaver.debug.DBGController;
import org.jkiss.dbeaver.debug.DBGEvent;
import org.jkiss.dbeaver.debug.DBGEventHandler;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.debug.DBGSession;
import org.jkiss.dbeaver.debug.core.DebugUtils;
import org.jkiss.dbeaver.debug.core.model.DatabaseDebugElement;
import org.jkiss.dbeaver.debug.core.model.DatabaseThread;
import org.jkiss.dbeaver.debug.core.model.IDatabaseDebugTarget;
import org.jkiss.dbeaver.debug.internal.core.DebugCoreMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DefaultProgressMonitor;
import org.jkiss.dbeaver.utils.GeneralUtils;
import org.jkiss.dbeaver.utils.RuntimeUtils;

public class DatabaseDebugTarget
extends DatabaseDebugElement
implements IDatabaseDebugTarget,
DBGEventHandler {
    private static final Log log = Log.getLog(DatabaseDebugTarget.class);
    public static final int BREAKPOINT_ACTION_TIMEOUT = 20000;
    public static final int SESSION_ACTION_TIMEOUT = 20000;
    private final String modelIdentifier;
    private final ILaunch launch;
    private final IProcess process;
    private final DBGController controller;
    private final List<IThread> threads;
    private final DatabaseThread thread;
    private String name;
    private String defaultName = DebugCoreMessages.DatabaseDebugTarget_name_default;
    private boolean suspended = false;
    private boolean terminated = false;
    private DBGSession session;

    public DatabaseDebugTarget(String modelIdentifier, ILaunch launch, IProcess process, DBGController controller) {
        super(null);
        this.modelIdentifier = modelIdentifier;
        this.launch = launch;
        this.process = process;
        this.controller = controller;
        this.controller.registerEventHandler(this);
        this.threads = new ArrayList<IThread>();
        this.thread = this.newThread();
        this.threads.add(this.thread);
        DebugPlugin debugPlugin = DebugPlugin.getDefault();
        IBreakpointManager breakpointManager = debugPlugin.getBreakpointManager();
        breakpointManager.addBreakpointManagerListener((IBreakpointManagerListener)this);
        breakpointManager.addBreakpointListener((IBreakpointListener)this);
        debugPlugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    @Override
    public IDatabaseDebugTarget getDatabaseDebugTarget() {
        return this;
    }

    @Override
    public DBGController getController() {
        return this.controller;
    }

    @Override
    public DBGSession getSession() {
        return this.session;
    }

    protected DatabaseThread newThread() {
        return new DatabaseThread(this);
    }

    public IDebugTarget getDebugTarget() {
        return this;
    }

    @Override
    public String getModelIdentifier() {
        return this.modelIdentifier;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IProcess getProcess() {
        return this.process;
    }

    public IThread[] getThreads() throws DebugException {
        return this.threads.toArray(new IThread[this.threads.size()]);
    }

    public boolean hasThreads() throws DebugException {
        return !this.terminated && this.threads.size() > 0;
    }

    public String getName() throws DebugException {
        if (this.name == null) {
            try {
                ILaunchConfiguration configuration = this.getLaunch().getLaunchConfiguration();
                this.name = this.getConfiguredName(configuration);
                if (this.name == null) {
                    this.name = this.getDefaultName();
                }
            }
            catch (CoreException e) {
                this.name = this.getDefaultName();
            }
        }
        return this.name;
    }

    protected String getConfiguredName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getName();
    }

    protected String getDefaultName() {
        return this.defaultName;
    }

    protected void setDefaultName(String defaultName) {
        this.defaultName = defaultName;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        block5: for (DebugEvent event : events) {
            switch (event.getKind()) {
                case 8: {
                    if (!event.getSource().equals(this.process)) continue block5;
                    try {
                        this.terminated();
                        continue block5;
                    }
                    catch (DebugException e) {
                        log.log(e.getStatus());
                    }
                }
            }
        }
    }

    @Override
    public void connect(IProgressMonitor monitor) throws CoreException {
        DefaultProgressMonitor dbm = new DefaultProgressMonitor(monitor);
        try {
            this.session = this.controller.openSession((DBRProgressMonitor)dbm);
        }
        catch (DBGException e) {
            this.process.terminate();
            throw new CoreException(GeneralUtils.makeExceptionStatus((Throwable)((Object)e)));
        }
        IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints(this.modelIdentifier);
        if (breakpoints != null) {
            for (IBreakpoint bp : breakpoints) {
                DBGBreakpointDescriptor descriptor = this.describeBreakpoint(bp);
                if (descriptor == null) continue;
                try {
                    this.session.addBreakpoint((DBRProgressMonitor)dbm, descriptor);
                }
                catch (DBGException e) {
                    log.error((Object)"Can't add initial breakpoint", (Throwable)((Object)e));
                }
            }
        }
    }

    public boolean canTerminate() {
        return !this.terminated;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void terminate() throws DebugException {
        this.terminated();
    }

    public synchronized void terminated() throws DebugException {
        if (!this.terminated) {
            this.threads.clear();
            this.terminated = true;
            this.suspended = false;
            try {
                this.disconnect();
                this.controller.unregisterEventHandler(this);
            }
            finally {
                this.controller.dispose();
            }
            DebugPlugin debugPlugin = DebugPlugin.getDefault();
            if (debugPlugin != null) {
                IBreakpointManager breakpointManager = debugPlugin.getBreakpointManager();
                breakpointManager.removeBreakpointListener((IBreakpointListener)this);
                debugPlugin.removeDebugEventListener((IDebugEventSetListener)this);
                breakpointManager.removeBreakpointManagerListener((IBreakpointManagerListener)this);
            }
            if (!this.getProcess().isTerminated()) {
                try {
                    this.process.terminate();
                }
                catch (DebugException e) {
                    log.debug((Object)e);
                }
            }
            if (debugPlugin != null) {
                this.fireTerminateEvent();
            }
        }
    }

    public boolean canResume() {
        return this.thread != null && !this.terminated && this.suspended;
    }

    public boolean canSuspend() {
        return this.thread != null && !this.terminated && !this.suspended;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void resume() throws DebugException {
        this.suspended = false;
        try {
            this.session.resume();
        }
        catch (DBGException e) {
            log.error((Object)e);
            throw new DebugException(GeneralUtils.makeErrorStatus((String)NLS.bind((String)"Error resuming {0} - {1}", (Object)this.getName(), (Object)e.getMessage())));
        }
        if (this.thread.isSuspended()) {
            this.thread.resumedByTarget();
        }
        this.fireResumeEvent(32);
    }

    public void suspend() throws DebugException {
        try {
            this.session.suspend();
        }
        catch (DBGException e) {
            log.error((Object)e);
            throw new DebugException(GeneralUtils.makeErrorStatus((String)NLS.bind((String)"Error suspending {0} - {1}", (Object)this.getName(), (Object)e.getMessage())));
        }
    }

    public void suspended(int detail) {
        this.suspended = true;
        this.thread.setStepping(false);
        this.thread.fireSuspendEvent(detail);
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        return breakpoint.getModelIdentifier().equals("org.jkiss.dbeaver.debug.core.databaseLineBreakpointMarker");
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        if (!this.terminated) {
            DBGBreakpointDescriptor descriptor = this.describeBreakpoint(breakpoint);
            if (descriptor == null) {
                log.error((Object)NLS.bind((String)"Unable to describe breakpoint {0}", (Object)breakpoint));
                return;
            }
            RuntimeUtils.runTask(monitor -> {
                try {
                    this.session.addBreakpoint(monitor, descriptor);
                }
                catch (DBGException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
            }, (String)"Add session breakpoint", (long)20000L);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (!this.terminated) {
            DBGBreakpointDescriptor descriptor = this.describeBreakpoint(breakpoint);
            if (descriptor == null) {
                log.error((Object)NLS.bind((String)"Unable to describe breakpoint {0}", (Object)breakpoint));
                return;
            }
            RuntimeUtils.runTask(monitor -> {
                try {
                    this.session.removeBreakpoint(monitor, descriptor);
                }
                catch (DBGException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
            }, (String)"Remove session breakpoint", (long)20000L);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        if (this.supportsBreakpoint(breakpoint)) {
            try {
                if (breakpoint.isEnabled() && DebugPlugin.getDefault().getBreakpointManager().isEnabled()) {
                    this.breakpointAdded(breakpoint);
                } else {
                    this.breakpointRemoved(breakpoint, null);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    public void breakpointManagerEnablementChanged(boolean enabled) {
        IBreakpoint[] breakpoints;
        for (IBreakpoint breakpoint : breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.jkiss.dbeaver.debug.core.databaseLineBreakpointMarker")) {
            if (enabled) {
                this.breakpointAdded(breakpoint);
                continue;
            }
            this.breakpointRemoved(breakpoint, null);
        }
    }

    protected DBGBreakpointDescriptor describeBreakpoint(IBreakpoint breakpoint) {
        HashMap<String, Object> description = new HashMap<String, Object>();
        try {
            Map attributes = breakpoint.getMarker().getAttributes();
            Map<String, Object> remote = DebugUtils.toBreakpointDescriptor(attributes);
            description.putAll(remote);
        }
        catch (CoreException e) {
            log.log(e.getStatus());
            return null;
        }
        return this.controller.describeBreakpoint(description);
    }

    public boolean canDisconnect() {
        return this.session != null;
    }

    public void disconnect() throws DebugException {
        if (this.session != null) {
            RuntimeUtils.runTask(monitor -> {
                try {
                    this.session.closeSession(monitor);
                }
                catch (DBGException e) {
                    throw new InvocationTargetException((Throwable)((Object)e));
                }
            }, (String)"Close session", (long)20000L);
            this.session = null;
        }
    }

    public boolean isDisconnected() {
        return this.session == null;
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        return null;
    }

    @Override
    public void handleDebugEvent(DBGEvent event) {
        int kind = event.getKind();
        if (2 == kind) {
            this.suspended(event.getDetails());
        }
        if (8 == kind) {
            try {
                this.process.terminate();
            }
            catch (DebugException e) {
                log.log(e.getStatus());
            }
        }
    }

    @Override
    public boolean canStepInto() {
        return this.session != null && this.session.canStepInto();
    }

    @Override
    public boolean canStepOver() {
        return this.session != null && this.session.canStepOver();
    }

    @Override
    public boolean canStepReturn() {
        return this.session != null && this.session.canStepReturn();
    }

    @Override
    public void stepInto() throws DebugException {
        try {
            this.session.execStepInto();
        }
        catch (DBGException e) {
            String message = NLS.bind((String)"Step into failed for session {0}", (Object)this.session.getSessionId());
            Status status = DebugUtils.newErrorStatus(message, (Throwable)((Object)e));
            throw new DebugException((IStatus)status);
        }
    }

    @Override
    public void stepOver() throws DebugException {
        try {
            this.session.execStepOver();
        }
        catch (DBGException e) {
            String message = NLS.bind((String)"Step over failed for session {0}", (Object)this.session.getSessionId());
            Status status = DebugUtils.newErrorStatus(message, (Throwable)((Object)e));
            throw new DebugException((IStatus)status);
        }
    }

    @Override
    public void stepReturn() throws DebugException {
        try {
            this.session.execStepReturn();
        }
        catch (DBGException e) {
            String message = NLS.bind((String)"Step return failed for session {0}", (Object)this.session.getSessionId());
            Status status = DebugUtils.newErrorStatus(message, (Throwable)((Object)e));
            throw new DebugException((IStatus)status);
        }
    }
}

