/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.debug;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.ListenerList;
import org.jkiss.dbeaver.DBException;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.debug.DBGController;
import org.jkiss.dbeaver.debug.DBGEvent;
import org.jkiss.dbeaver.debug.DBGEventHandler;
import org.jkiss.dbeaver.debug.DBGException;
import org.jkiss.dbeaver.debug.DBGSession;
import org.jkiss.dbeaver.debug.jdbc.DBGJDBCSession;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.messages.ModelMessages;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;

public abstract class DBGBaseController
implements DBGController {
    private static final Log log = Log.getLog(DBGBaseController.class);
    private final DBPDataSourceContainer dataSourceContainer;
    private final Map<String, Object> configuration;
    private ListenerList<DBGEventHandler> eventHandlers = new ListenerList();

    protected DBGBaseController(DBPDataSourceContainer dataSourceContainer, Map<String, Object> configuration) {
        this.dataSourceContainer = dataSourceContainer;
        this.configuration = new HashMap<String, Object>(configuration);
    }

    @Override
    public DBPDataSourceContainer getDataSourceContainer() {
        return this.dataSourceContainer;
    }

    @Override
    public Map<String, Object> getDebugConfiguration() {
        return new HashMap<String, Object>(this.configuration);
    }

    @Override
    public DBGSession openSession(DBRProgressMonitor monitor) throws DBGException {
        if (!this.dataSourceContainer.isConnected()) {
            try {
                this.dataSourceContainer.connect(monitor, true, true);
            }
            catch (DBException e) {
                throw new DBGException(e, this.dataSourceContainer.getDataSource());
            }
        }
        if (!this.dataSourceContainer.isConnected()) {
            throw new DBGException(ModelMessages.error_not_connected_to_database);
        }
        return this.createSession(monitor, this.configuration);
    }

    @Override
    public void dispose() {
        Object[] listeners;
        for (Object listener : listeners = this.eventHandlers.getListeners()) {
            this.unregisterEventHandler((DBGEventHandler)listener);
        }
    }

    public abstract DBGJDBCSession createSession(DBRProgressMonitor var1, Map<String, Object> var2) throws DBGException;

    @Override
    public void registerEventHandler(DBGEventHandler eventHandler) {
        this.eventHandlers.add((Object)eventHandler);
    }

    @Override
    public void unregisterEventHandler(DBGEventHandler eventHandler) {
        this.eventHandlers.remove((Object)eventHandler);
    }

    public void fireEvent(DBGEvent event) {
        for (DBGEventHandler eventHandler : this.eventHandlers) {
            eventHandler.handleDebugEvent(event);
        }
    }
}

